<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
//error_reporting(E_ALL);
//ini_set('display_errors', '1');

class Consultacpe extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        // YRegards constructor code
        $this->load->library("Aauth");
        $this->load->library("Captcha_u");
        $this->load->library("form_validation");
        $this->load->model('Consulta_model', 'consulta');
        $this->captcha = $this->captcha_u->public_key()->captcha;
        $this->load->library("Registerlog");

    }

    public function index()
    {        
        $data['response'] = '';
        $data['captcha_on'] = $this->captcha;
        $data['captcha'] = $this->captcha_u->public_key()->recaptcha_p;
        $data['tpcomp'] = $this->consulta->tipocomprobante();
        $data['moneda'] = $this->consulta->moneda();
        if ($this->input->get('e')) {
            $data['response'] = '¡No se encontraron datos, vuelve a intentalo más tarde!';
        }
        $this->load->view('consultacpe/header');
        $this->load->view('consultacpe/index', $data);
        $this->load->view('consultacpe/footer');


    }

    public function buscar()
    {
        $tipocomp = $this->input->post('tipocomp');
        $serie = $this->input->post('serie');
        $correlativo = $this->input->post('correlativo');
        $moneda = $this->input->post('moneda');
        $fecha = $this->input->post('fecha');
        $total = $this->input->post('total');
        
        $result = $this->consulta->buscar_cpe($tipocomp, $serie, $correlativo, $moneda, $fecha, $total);
        
        if ($result) {            
            foreach ($result as $row) {
                $validtoken = hash_hmac('ripemd160', $row['uid'], $this->config->item('encryption_key'));
                redirect('/billing/view?id='.$row['uid'].'&token='.$validtoken, 'refresh');
            }
        } else {

            redirect('/consultacpe/?e=error', 'refresh');
        }

    }


}
