<?php


defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . 'third_party/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Reports extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('reports_model', 'reports');
        $this->load->library("Aauth");
        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        if (!$this->aauth->premission(10)) {

            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $this->li_a = 'data';
        $this->load->library("Registerlog");
    }

    public function index()
    {
    }

    //Statistics

    public function statistics()
    {
        $data['stat'] = $this->reports->statistics();
        $head['title'] = "Statistics";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/stat', $data);
        $this->load->view('fixed/footer');
    }

    //accounts section

    public function accountstatement()

    {
        $this->load->model('transactions_model');
        $data['accounts'] = $this->transactions_model->acc_list();
        $head['title'] = "Estado de cuenta";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/statement', $data);
        $this->load->view('fixed/footer');
    }

    public function customerstatement()

    {
        $this->load->model('transactions_model');
        $data['accounts'] = $this->transactions_model->acc_list();
        $head['title'] = "Estado de cuenta";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/customer_statement', $data);
        $this->load->view('fixed/footer');
    }

    public function supplierstatement()

    {
        $this->load->model('transactions_model');
        $data['accounts'] = $this->transactions_model->acc_list();
        $head['title'] = "Estado de cuenta";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/supplier_statement', $data);
        $this->load->view('fixed/footer');
    }

    public function viewstatement()

    {
        $this->load->model('accounts_model', 'accounts');
        $pay_acc = $this->input->post('pay_acc');
        $trans_type = $this->input->post('trans_type');
        $sdate = datefordatabase($this->input->post('sdate'));
        $edate = datefordatabase($this->input->post('edate'));
        $ttype = $this->input->post('ttype');
        $account = $this->accounts->details($pay_acc);
        $data['filter'] = array($pay_acc, $trans_type, $sdate, $edate, $ttype, $account['holder']);
        $head['title'] = "Estado de cuenta";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/statement_list', $data);
        $this->load->view('fixed/footer');
    }

    public function customerviewstatement()

    {
        $this->load->model('customers_model', 'customer');
        $cid = $this->input->post('customer');
        $trans_type = $this->input->post('trans_type');
        $sdate = datefordatabase($this->input->post('sdate'));
        $edate = datefordatabase($this->input->post('edate'));
        $ttype = $this->input->post('ttype');
        $customer = $this->customer->details($cid);
        $data['filter'] = array($cid, $trans_type, $sdate, $edate, $ttype, $customer['name']);

        //  print_r( $data['statement']);
        $head['title'] = "Customer Account Statement";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/customerstatement_list', $data);
        $this->load->view('fixed/footer');
    }

    public function supplierviewstatement()

    {
        $this->load->model('supplier_model', 'supplier');
        $cid = $this->input->post('supplier');
        $trans_type = $this->input->post('trans_type');
        $sdate = datefordatabase($this->input->post('sdate'));
        $edate = datefordatabase($this->input->post('edate'));
        $ttype = $this->input->post('ttype');
        $customer = $this->supplier->details($cid);
        $data['filter'] = array($cid, $trans_type, $sdate, $edate, $ttype, $customer['name']);

        //  print_r( $data['statement']);
        $head['title'] = "Supplier Account Statement";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/supplierstatement_list', $data);
        $this->load->view('fixed/footer');
    }


    //

    public function statements()
    {

        $pay_acc = $this->input->post('ac');
        $trans_type = $this->input->post('ty');
        $sdate = datefordatabase($this->input->post('sd'));
        $edate = datefordatabase($this->input->post('ed'));
        $list = $this->reports->get_statements($pay_acc, $trans_type, $sdate, $edate);
        $balance = 0;

        foreach ($list as $row) {
            $balance += $row['credit'] - $row['debit'];
            echo '<tr><td>' . $row['date'] . '</td><td>' . $row['note'] . '</td><td>' . amountExchange($row['debit'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($row['credit'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($balance, 0, $this->aauth->get_user()->loc) . '</td></tr>';
        }
    }

    public function customerstatements()
    {


        $pay_acc = $this->input->post('ac');
        $trans_type = $this->input->post('ty');
        $sdate = datefordatabase($this->input->post('sd'));
        $edate = datefordatabase($this->input->post('ed'));


        $list = $this->reports->get_customer_statements($pay_acc, $trans_type, $sdate, $edate);
        $balance = 0;

        foreach ($list as $row) {
            $balance += $row['credit'] - $row['debit'];
            echo '<tr><td>' . $row['date'] . '</td><td>' . $row['note'] . '</td><td>' . amountExchange($row['debit'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($row['credit'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($balance, 0, $this->aauth->get_user()->loc) . '</td></tr>';
        }
    }

    public function supplierstatements()
    {


        $pay_acc = $this->input->post('ac');
        $trans_type = $this->input->post('ty');
        $sdate = datefordatabase($this->input->post('sd'));
        $edate = datefordatabase($this->input->post('ed'));


        $list = $this->reports->get_supplier_statements($pay_acc, $trans_type, $sdate, $edate);
        $balance = 0;

        foreach ($list as $row) {
            $balance += $row['debit'] - $row['credit'];
            echo '<tr><td>' . $row['date'] . '</td><td>' . $row['note'] . '</td><td>' . amountExchange($row['debit'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($row['credit'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($balance, 0, $this->aauth->get_user()->loc) . '</td></tr>';
        }
    }


    // income section


    public function incomestatement()

    {
        $head['title'] = "Income Statement";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);

        $this->load->model('transactions_model');
        $data['accounts'] = $this->transactions_model->acc_list();
        $data['income'] = $this->reports->incomestatement();


        $this->load->view('reports/incomestatement', $data);


        $this->load->view('fixed/footer');
    }


    public function customincome()
    {

        if ($this->input->post('check')) {
            $acid = $this->input->post('pay_acc');
            $sdate = datefordatabase($this->input->post('sdate'));
            $edate = datefordatabase($this->input->post('edate'));

            $date1 = new DateTime($sdate);
            $date2 = new DateTime($edate);

            $diff = $date2->diff($date1)->format("%a");
            if ($diff < 365) {
                $income = $this->reports->customincomestatement($acid, $sdate, $edate);

                echo json_encode(array('status' => 'Success', 'message' => 'Calculado', 'param1' => '<hr><b>Los ingresos entre las fechas son ' . amountExchange($income['credit'], 0, $this->aauth->get_user()->loc) . '</b>'));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => 'El intervalo de fechas debe estar dentro de los 365 días.', 'param1' => ''));
            }
        }
    }

    // expense section


    public function expensestatement()

    {
        $head['title'] = "Expense Statement";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);

        $this->load->model('transactions_model');
        $data['accounts'] = $this->transactions_model->acc_list();
        $data['income'] = $this->reports->expensestatement();


        $this->load->view('reports/expensestatement', $data);


        $this->load->view('fixed/footer');
    }


    public function customexpense()
    {

        if ($this->input->post('check')) {
            $acid = $this->input->post('pay_acc');
            $sdate = datefordatabase($this->input->post('sdate'));
            $edate = datefordatabase($this->input->post('edate'));

            $date1 = new DateTime($sdate);
            $date2 = new DateTime($edate);

            $diff = $date2->diff($date1)->format("%a");
            if ($diff < 365) {
                $income = $this->reports->customexpensestatement($acid, $sdate, $edate);

                echo json_encode(array('status' => 'Success', 'message' => 'Calculated', 'param1' => '<hr><b>Expense between the dates is ' . amountExchange($income['debit'], 0, $this->aauth->get_user()->loc) . '</b>'));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => 'Date range should be within 365 days', 'param1' => ''));
            }
        }
    }


    public function refresh_data()

    {


        $head['title'] = "Refreshing Reports";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/refresh_data');
        $this->load->view('fixed/footer');
    }

    public function refresh_process()

    {

        $this->load->model('cronjob_model');
        if ($this->cronjob_model->reports()) {

            echo json_encode(array('status' => 'Success', 'message' => $this->lang->line('Calculated')));
        }
    }

    public function taxstatement()

    {
        $this->load->model('transactions_model');
        $data['accounts'] = $this->transactions_model->acc_list();
        $head['title'] = "Declaración de Impuestos";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->model('locations_model');
        $data['locations'] = $this->locations_model->locations_list();
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/tax_statement', $data);
        $this->load->view('fixed/footer');
    }

    public function taxviewstatement()

    {


        $trans_type = $this->input->post('ty');
        $sdate = datefordatabase($this->input->post('sdate'));
        $edate = datefordatabase($this->input->post('edate'));
        $lid = $this->input->post('lid');
        $data['filter'] = array($sdate, $edate, $trans_type, $lid);


        //  print_r( $data['statement']);
        $head['title'] = "Declaración de Impuestos";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('reports/tax_out', $data);
        $this->load->view('fixed/footer');
    }

    public function taxviewstatements_load()
    {


        $trans_type = $this->input->post('ty');
        $sdate = datefordatabase($this->input->post('sd'));
        $edate = datefordatabase($this->input->post('ed'));
        $lid = $this->input->post('loc');

        if ($trans_type == 'Sales') {
            $where = " WHERE (DATE(jsoft_invoices.invoicedate) BETWEEN '$sdate' AND '$edate' )";
            if ($lid > 0) $where .= " AND (jsoft_invoices.loc=$lid)";
            $query = $this->db->query("SELECT jsoft_customers.taxid AS VAT_Number,jsoft_invoices.tid AS invoice_number,jsoft_invoices.total AS amount,jsoft_invoices.tax AS tax,jsoft_customers.name AS customer_name,jsoft_customers.company AS Company_Name,jsoft_invoices.invoicedate AS date FROM jsoft_invoices LEFT JOIN jsoft_customers ON jsoft_invoices.csd=jsoft_customers.id" . $where);
        } else {

            $where = " WHERE (DATE(jsoft_purchase.invoicedate) BETWEEN '$sdate' AND '$edate') ";
            if ($lid > 0) $where .= " AND (jsoft_invoices.loc=$lid)";
            $query = $this->db->query("SELECT jsoft_supplier.taxid AS VAT_Number,jsoft_purchase.tid AS invoice_number,jsoft_purchase.total AS amount,jsoft_purchase.tax AS tax,jsoft_supplier.name AS customer_name,jsoft_supplier.company AS Company_Name,jsoft_purchase.invoicedate AS date FROM jsoft_purchase LEFT JOIN jsoft_supplier ON jsoft_purchase.csd=jsoft_supplier.id" . $where);
        }


        //echo $where;


        $balance = 0;

        foreach ($query->result_array() as $row) {
            $balance += $row['tax'];
            echo '<tr><td>' . $row['invoice_number'] . '</td><td>' . $row['customer_name'] . '</td><td>' . $row['VAT_Number'] . '</td><td>' . amountExchange($row['amount'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($row['tax'], 0, $this->aauth->get_user()->loc) . '</td><td>' . amountExchange($balance, 0, $this->aauth->get_user()->loc) . '</td></tr>';
        }
    }

    // profit section


    public function profitstatement()

    {
        $head['title'] = "Profit Statement";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);

        $this->load->model('locations_model');
        $data['locations'] = $this->locations_model->locations_list2();
        $data['income'] = $this->reports->profitstatement();


        $this->load->view('reports/profitstatement', $data);


        $this->load->view('fixed/footer');
    }


    public function customprofit()
    {

        if ($this->input->post('check')) {
            $lid = $this->input->post('pay_acc');
            $sdate = datefordatabase($this->input->post('sdate'));
            $edate = datefordatabase($this->input->post('edate'));

            $date1 = new DateTime($sdate);
            $date2 = new DateTime($edate);

            if ($this->aauth->get_user()->loc) {
                $lid = $this->aauth->get_user()->loc;
            }

            $diff = $date2->diff($date1)->format("%a");
            if ($diff < 365) {
                $income = $this->reports->customprofitstatement($lid, $sdate, $edate);

                echo json_encode(array('status' => 'Success', 'message' => 'Calculado', 'param1' => '<hr> El beneficio entre las fechas es ' . amountExchange($income['col1'], 0, $this->aauth->get_user()->loc) . ' '));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => 'El intervalo de fechas debe estar dentro de los 365 días.', 'param1' => ''));
            }
        }
    }

    // profit section


    public function sales()

    {
        $head['title'] = "Declaración de ventas";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);

        $this->load->model('locations_model');
        $data['locations'] = $this->locations_model->locations_list();
        $data['income'] = $this->reports->salesstatement();


        $this->load->view('reports/sales', $data);


        $this->load->view('fixed/footer');
    }

    public function ventas()

    {
        $head['title'] = "Reporte de Ventas";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);

        $this->load->model('locations_model');
        $data['locations'] = $this->locations_model->locations_list();
        $data['income'] = $this->reports->salesstatement();


        $this->load->view('reports/ventas', $data);


        $this->load->view('fixed/footer');
    }


    public function customsales()
    {

        if ($this->input->post('check')) {
            $lid = $this->input->post('pay_acc');
            $sdate = datefordatabase($this->input->post('sdate'));
            $edate = datefordatabase($this->input->post('edate'));

            $date1 = new DateTime($sdate);
            $date2 = new DateTime($edate);

            if ($this->aauth->get_user()->loc) {
                $lid = $this->aauth->get_user()->loc;
            }

            $diff = $date2->diff($date1)->format("%a");
            if ($diff < 365) {
                $income = $this->reports->customsalesstatement($lid, $sdate, $edate);

                echo json_encode(array('status' => 'Success', 'message' => 'Calculado', 'param1' => '<hr> Las ventas entre las fechas son ' . amountExchange($income['total'], 0, $this->aauth->get_user()->loc) . ''));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => 'Date range should be within 365 days', 'param1' => ''));
            }
        }
    }

    public function exportar_comprobantes_excel()
    {

        $sdate = $this->input->get('sdate');
        $edate = $this->input->get('edate');
        $archivo = "Reporte_Ventas_{$sdate}_{$edate}.xlsx";
        $lid = $this->input->get('pay_acc');



        if ($this->aauth->get_user()->loc) {
            $lid = $this->aauth->get_user()->loc;
        }

        $data = $this->reports->ventasstatement($sdate, $edate, $lid, 'B');
        $spread = new Spreadsheet();

        $spread->getProperties()
            ->setCreator("JSOFT SOLUTIONS")
            ->setLastModifiedBy("StartFACT")
            ->setTitle("REPORTE DE VENTAS")
            ->setSubject("Reporte generado automáticamente")
            ->setDescription("Reporte de ventas por periodo")
            ->setKeywords("reporte de ventas")
            ->setCategory("Reporte");

        $spread->setActiveSheetIndex(0);
        $sheet = $spread->getActiveSheet()->setTitle('BOLETAS');

        $contador = 1;

        $sheet->getColumnDimension('A')->setWidth(20);
        $sheet->getColumnDimension('B')->setWidth(8);
        $sheet->getColumnDimension('C')->setWidth(10);
        $sheet->getColumnDimension('D')->setWidth(10);
        $sheet->getColumnDimension('E')->setWidth(15);
        $sheet->getColumnDimension('F')->setWidth(40);
        $sheet->getColumnDimension('G')->setWidth(15);
        $sheet->getColumnDimension('H')->setWidth(20);
        $sheet->getColumnDimension('I')->setWidth(20);
        $sheet->getColumnDimension('J')->setWidth(20);
        $sheet->getColumnDimension('K')->setWidth(20);
        $sheet->getColumnDimension('L')->setWidth(20);

        $sheet->getStyle("A" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("B" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("C" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("D" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("E" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("F" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("G" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("H" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("I" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("J" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("K" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("L" . $contador)->getFont()->setBold(true);

        $sheet->setCellValue("A" . $contador, 'FECHA');
        $sheet->setCellValue("B" . $contador, 'TIPO');
        $sheet->setCellValue("C" . $contador, 'SERIE');
        $sheet->setCellValue("D" . $contador, 'Número');
        $sheet->setCellValue("E" . $contador, 'RUC,DNI,ETC');
        $sheet->setCellValue("F" . $contador, 'CLIENTE');
        $sheet->setCellValue("G" . $contador, 'REFERENCIA');
        $sheet->setCellValue("H" . $contador, 'MONEDA');
        $sheet->setCellValue("I" . $contador, 'ICBPER');
        $sheet->setCellValue("J" . $contador, 'TOTAL');
        $sheet->setCellValue("K" . $contador, 'SUNAT');
        $sheet->setCellValue("L" . $contador, 'DETALLE');

        foreach ($data as $value) {
            $contador++;
            $sheet->setCellValue("A" . $contador, $value['invoicedate']);
            $sheet->setCellValue("B" . $contador, $value['numtipo_comprobante']);
            $sheet->setCellValue("C" . $contador, $value['serie']);
            $sheet->setCellValue("d" . $contador, $value['tid']);
            $sheet->setCellValue("E" . $contador, $value['numdoc']);
            $sheet->setCellValue("F" . $contador, $value['name']);
            $sheet->setCellValue("G" . $contador, $value['refer']);
            $sheet->setCellValue("H" . $contador, 'PEN');
            $sheet->setCellValue("I" . $contador, $value['icbper']);
            $sheet->setCellValue("J" . $contador, $value['total']);
            $sheet->setCellValue("K" . $contador, $value['sunat']);
            $sheet->setCellValue("L" . $contador, $value['detalle']);
        }

        $data1 = $this->reports->ventasstatement($sdate, $edate, $lid, 'F');
        $sheet = $spread->createSheet();
        $sheet->setTitle('FACTURAS');

        $contador = 1;

        $sheet->getColumnDimension('A')->setWidth(20);
        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(20);
        $sheet->getColumnDimension('D')->setWidth(20);
        $sheet->getColumnDimension('E')->setWidth(20);
        $sheet->getColumnDimension('F')->setWidth(40);
        $sheet->getColumnDimension('G')->setWidth(20);
        $sheet->getColumnDimension('H')->setWidth(20);
        $sheet->getColumnDimension('I')->setWidth(20);
        $sheet->getColumnDimension('J')->setWidth(20);
        $sheet->getColumnDimension('K')->setWidth(20);
        $sheet->getColumnDimension('L')->setWidth(20);

        $sheet->getStyle("A" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("B" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("C" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("D" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("E" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("F" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("G" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("H" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("I" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("J" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("K" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("L" . $contador)->getFont()->setBold(true);

        $sheet->setCellValue("A" . $contador, 'FECHA');
        $sheet->setCellValue("B" . $contador, 'TIPO');
        $sheet->setCellValue("C" . $contador, 'SERIE');
        $sheet->setCellValue("D" . $contador, 'Número');
        $sheet->setCellValue("E" . $contador, 'RUC,DNI,ETC');
        $sheet->setCellValue("F" . $contador, 'CLIENTE');
        $sheet->setCellValue("G" . $contador, 'REFERENCIA');
        $sheet->setCellValue("H" . $contador, 'MONEDA');
        $sheet->setCellValue("I" . $contador, 'ICBPER');
        $sheet->setCellValue("J" . $contador, 'TOTAL');
        $sheet->setCellValue("K" . $contador, 'SUNAT');
        $sheet->setCellValue("L" . $contador, 'DETALLE');

        foreach ($data1 as $value) {
            $contador++;
            $sheet->setCellValue("A" . $contador, $value['invoicedate']);
            $sheet->setCellValue("B" . $contador, $value['numtipo_comprobante']);
            $sheet->setCellValue("C" . $contador, $value['serie']);
            $sheet->setCellValue("d" . $contador, $value['tid']);
            $sheet->setCellValue("E" . $contador, $value['numdoc']);
            $sheet->setCellValue("F" . $contador, $value['name']);
            $sheet->setCellValue("G" . $contador, $value['refer']);
            $sheet->setCellValue("H" . $contador, 'PEN');
            $sheet->setCellValue("I" . $contador, $value['icbper']);
            $sheet->setCellValue("J" . $contador, $value['total']);
            $sheet->setCellValue("K" . $contador, $value['sunat']);
            $sheet->setCellValue("L" . $contador, $value['detalle']);
        }

        $data = $this->reports->ncstatement($sdate, $edate, $lid);
        $sheet = $spread->createSheet();
        $sheet->setTitle('NOTAS DE CRÉDITO');

        $contador = 1;

        $sheet->getColumnDimension('A')->setWidth(20);
        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(20);
        $sheet->getColumnDimension('D')->setWidth(20);
        $sheet->getColumnDimension('E')->setWidth(20);
        $sheet->getColumnDimension('F')->setWidth(40);
        $sheet->getColumnDimension('G')->setWidth(20);
        $sheet->getColumnDimension('H')->setWidth(20);
        $sheet->getColumnDimension('I')->setWidth(20);
        $sheet->getColumnDimension('J')->setWidth(20);
        $sheet->getColumnDimension('K')->setWidth(20);
        $sheet->getColumnDimension('L')->setWidth(20);
        $sheet->getColumnDimension('M')->setWidth(20);

        $sheet->getStyle("A" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("B" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("C" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("D" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("E" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("F" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("G" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("H" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("I" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("J" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("K" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("L" . $contador)->getFont()->setBold(true);
        $sheet->getStyle("M" . $contador)->getFont()->setBold(true);

        $sheet->setCellValue("A" . $contador, 'FECHA');
        $sheet->setCellValue("B" . $contador, 'TIPO');
        $sheet->setCellValue("C" . $contador, 'SERIE');
        $sheet->setCellValue("D" . $contador, 'Número');
        $sheet->setCellValue("E" . $contador, 'RUC,DNI,ETC');
        $sheet->setCellValue("F" . $contador, 'CLIENTE');
        $sheet->setCellValue("G" . $contador, 'REFERENCIA');
        $sheet->setCellValue("H" . $contador, 'MONEDA');
        $sheet->setCellValue("I" . $contador, 'ICBPER');
        $sheet->setCellValue("J" . $contador, 'TOTAL');
        $sheet->setCellValue("K" . $contador, 'MOTIVO');
        $sheet->setCellValue("L" . $contador, 'SUNAT');
        $sheet->setCellValue("M" . $contador, 'DETALLE');

        foreach ($data as $value) {
            $contador++;
            $sheet->setCellValue("A" . $contador, $value['invoicedate']);
            $sheet->setCellValue("B" . $contador, $value['numtipo_comprobante']);
            $sheet->setCellValue("C" . $contador, $value['serie']);
            $sheet->setCellValue("d" . $contador, $value['tid']);
            $sheet->setCellValue("E" . $contador, $value['numdoc']);
            $sheet->setCellValue("F" . $contador, $value['name']);
            $sheet->setCellValue("G" . $contador, $value['refer']);
            $sheet->setCellValue("H" . $contador, 'PEN');
            $sheet->setCellValue("I" . $contador, $value['icbper']);
            $sheet->setCellValue("J" . $contador, $value['total']);
            $sheet->setCellValue("K" . $contador, $value['notes']);
            $sheet->setCellValue("L" . $contador, $value['sunat']);
            $sheet->setCellValue("M" . $contador, $value['detalle']);
        }



        $writer = new Xlsx($spread);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($archivo) . '"');
        $writer->save('php://output');
    }
       


    // products section
    public function products()

    {
        $head['title'] = "Products Statement";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->model('locations_model');
        $this->load->model('categories_model');
        $data['locations'] = $this->locations_model->locations_list();
        $data['cat'] = $this->categories_model->category_list();
        $data['income'] = $this->reports->productsstatement();
        $this->load->view('reports/products', $data);
        $this->load->view('fixed/footer');
    }


    public function customproducts()
    {
        if ($this->input->post('check')) {
            $lid = $this->input->post('pay_acc');
            $sdate = datefordatabase($this->input->post('sdate'));
            $edate = datefordatabase($this->input->post('edate'));
            $date1 = new DateTime($sdate);
            $date2 = new DateTime($edate);
            $diff = $date2->diff($date1)->format("%a");
            if ($this->aauth->get_user()->loc) {
                $lid = $this->aauth->get_user()->loc;
            }
            if ($diff < 365) {
                $income = $this->reports->customproductsstatement($lid, $sdate, $edate);
                echo json_encode(array('status' => 'Success', 'message' => 'Calculado', 'param1' => '<hr>Las ventas de productos entre las fechas son ' . amountExchange($income['subtotal'], 0, $this->aauth->get_user()->loc) . ' <br> Qty between the dates is ' . amountFormat_general($income['qty']) . '.'));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => 'Date range should be within 365 days', 'param1' => ''));
            }
        }
    }

    public function customproducts_cat()
    {
        if ($this->input->post('check')) {
            $lid = $this->input->post('pay_acc');
            $sdate = datefordatabase($this->input->post('sdate'));
            $edate = datefordatabase($this->input->post('edate'));
            $date1 = new DateTime($sdate);
            $date2 = new DateTime($edate);
            $diff = $date2->diff($date1)->format("%a");
            if ($this->aauth->get_user()->loc) {
                $lid = $this->aauth->get_user()->loc;
            }
            if ($diff < 365) {
                $income = $this->reports->customproductsstatement_cat($lid, $sdate, $edate);
                echo json_encode(array('status' => 'Success', 'message' => 'Calculado', 'param1' => '<hr>Las ventas de productos entre las fechas son ' . amountExchange($income['subtotal'], 0, $this->aauth->get_user()->loc) . ' Qty between the dates is ' . amountFormat_general($income['qty']) . '.'));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => 'Date range should be within 365 days', 'param1' => ''));
            }
        }
    }

    public function fetch_data()
    {
        if ($this->input->get('p')) {

            $data = $this->reports->fetchdata($this->input->get('p'));
            echo json_encode(array('status' => 'Success', 'message' => 'Calculated', 'p1' => $data['p1'], 'p2' => $data['p2'], 'p3' => $data['p3'], 'p4' => $data['p4']));
        }
    }

    public function commission()

    {
        if ($this->input->post('check')) {
            $lid = $this->input->post('pay_acc');
            $sdate = datefordatabase($this->input->post('sdate'));
            $edate = datefordatabase($this->input->post('edate'));

            $date1 = new DateTime($sdate);
            $date2 = new DateTime($edate);

            if ($this->aauth->get_user()->loc) {
                $lid = $this->aauth->get_user()->loc;
            }

            $diff = $date2->diff($date1)->format("%a");
            if ($diff < 365) {
                $commission = $this->reports->customcommission($lid, $sdate, $edate);

                echo json_encode(array('status' => 'Success', 'message' => 'Calculated', 'param1' => 'Commission between the dates is ' . amountExchange($commission, 0, $this->aauth->get_user()->loc)));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => 'Date range should be within 365 days', 'param1' => ''));
            }
        } else {
            $head['title'] = "Commission";
            $head['usernm'] = $this->aauth->get_user()->username;
            $this->load->view('fixed/header', $head);

            $this->load->model('employee_model');
            $data['employee'] = $this->employee_model->list_employee();

            $this->load->view('reports/commission', $data);


            $this->load->view('fixed/footer');
        }
    }
}
