<?php


defined('BASEPATH') or exit('No direct script access allowed');

class Search_products extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library("Aauth");
        $this->load->model('search_model');
        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        if (!$this->aauth->premission(1)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $this->load->library("Registerlog");
    }

//buscar producto en factura
    public function search()
    {
        $this->load->model('plugins_model', 'plugins');
        $billing_settings = $this->plugins->universal_api(67);
        $result = array();
        $out = array();
        $row_num = $this->input->post('row_num', true);
        $name = $this->input->post('name_startsWith', true);
        $wid = $this->input->post('wid', true);
        $qw = '';
        if ($wid > 0) {
            $qw = "(jsoft_products.warehouse='$wid') AND ";
        }
        if ($billing_settings['key2']) $qw .= "(jsoft_products.expiry IS NULL OR DATE (jsoft_products.expiry)<" . date('Y-m-d') . ") AND ";
        $join = '';

        if ($this->aauth->get_user()->loc) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=jsoft_products.warehouse';
            $join2 = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=jsoft_products.warehouse';
            if (BDATA) $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' OR jsoft_warehouse.loc=0) AND '; else $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' ) AND ';
        } elseif (!BDATA) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=jsoft_products.warehouse';
            $qw .= '(jsoft_warehouse.loc=0) AND ';
        }
        $e = '';
        if ($billing_settings['key1'] == 1) {
            $e .= ',jsoft_product_serials.serial';
            $join .= 'LEFT JOIN jsoft_product_serials ON jsoft_product_serials.product_id=jsoft_products.pid';
            $qw .= '(jsoft_product_serials.status=0) AND ';
        }

        if ($name) {

            if ($billing_settings['key1'] == 2) {
                $e .= ',jsoft_product_serials.serial';
                $query = $this->db->query("SELECT jsoft_products.pid,jsoft_products.product_name,jsoft_products.talla,jsoft_products.product_price,jsoft_products.product_code,jsoft_products.taxrate,jsoft_products.disrate,jsoft_products.product_des,jsoft_products.qty,jsoft_products.unit, jsoft_products.icbper $e  FROM jsoft_product_serials LEFT JOIN jsoft_products  ON jsoft_products.pid=jsoft_product_serials.product_id $join WHERE " . $qw . "(UPPER(jsoft_product_serials.serial) LIKE '" . strtoupper($name) . "%')  LIMIT 6");
            } else {
                $query = $this->db->query("SELECT jsoft_products.pid,jsoft_products.product_name, jsoft_products.talla,jsoft_products.product_price,jsoft_products.product_code,jsoft_products.taxrate,jsoft_products.disrate,jsoft_products.product_des,jsoft_products.qty,jsoft_products.unit, jsoft_products.icbper $e  FROM jsoft_products $join WHERE " . $qw . "(UPPER(jsoft_products.product_name) LIKE '%" . strtoupper($name) . "%') OR (UPPER(jsoft_products.product_code) LIKE '" . strtoupper($name) . "%') LIMIT 6");
            }

            $result = $query->result_array();
            foreach ($result as $row) {
                $name = array($row['product_name'], $row['talla'], amountExchange_s($row['product_price'], 0, $this->aauth->get_user()->loc), $row['pid'], amountFormat_general($row['taxrate']), amountFormat_general($row['disrate']), $row['product_des'], $row['unit'], $row['product_code'], amountFormat_general($row['qty']), $row_num, @$row['serial'], amountExchange_s($row['icbper'], 0, $this->aauth->get_user()->loc));
                array_push($out, $name);
            }
            echo json_encode($out);
        }
    }
    public function qsearch()
    {
        $this->load->model('plugins_model', 'plugins');
        $billing_settings = $this->plugins->universal_api(67);
        $result = array();
        $out = array();
        $row_num = $this->input->post('row_num', true);
        $name = $this->input->post('name_startsWith', true);
        $wid = $this->input->post('wid', true);
        
        if ($name) {
            $query = $this->db->query("select DISTINCT product, talla from jsoft_quotes_items");            
            $result = $query->result_array();
            foreach ($result as $row) {
                $name = array($row['product'], $row['talla']);
                array_push($out, $name);
            }
            echo json_encode($out);
        }
    }

    public function puchase_search()
    {
        $result = array();
        $out = array();
        $row_num = $this->input->post('row_num', true);
        $name = $this->input->post('name_startsWith', true);
        $wid = $this->input->post('wid', true);
        $qw = '';
        if ($wid > 0) {
            $qw = "(v_jsoft_productos.warehouse='$wid' ) AND ";
        }
        $join = '';
        if ($this->aauth->get_user()->loc) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=v_jsoft_productos.warehouse';
            if (BDATA) $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' OR jsoft_warehouse.loc=0) AND '; else $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' ) AND ';
        } elseif (!BDATA) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=v_jsoft_productos.warehouse';
            $qw .= '(jsoft_warehouse.loc=0) AND ';
        }
        if ($name) {
            $query = $this->db->query("SELECT * FROM v_jsoft_productos $join WHERE " . $qw . "UPPER(v_jsoft_productos.producto) LIKE '%" . strtoupper($name) . "%' OR UPPER(v_jsoft_productos.barcode) LIKE '" . strtoupper($name) . "%'");

            $result = $query->result_array();
            foreach ($result as $row) {
                $name = array($row['producto'],$row['talla'], amountExchange_s($row['fproduct_price'], 0, $this->aauth->get_user()->loc), $row['pid'], amountFormat_general($row['taxrate']), amountFormat_general($row['disrate']), $row['product_des'], $row['unit'], $row['product_code'], $row_num);
                array_push($out, $name);
            }

            echo json_encode($out);
        }
    }

    public function csearch()
    {
        $result = array();
        $out = array();
        $name = $this->input->get('keyword', true);
        $whr = '';
        if ($this->aauth->get_user()->loc) {
            $whr = ' (loc=' . $this->aauth->get_user()->loc . ' OR loc=0) AND ';
            if (!BDATA) $whr = ' (loc=' . $this->aauth->get_user()->loc . ' ) AND ';
        } elseif (!BDATA) {
            $whr = ' (loc=0) AND ';
        }
        if ($name) {
            $query = $this->db->query("SELECT id,name,iddoc,address,city,phone,email,discount_c FROM jsoft_customers WHERE $whr (UPPER(name)  LIKE '%" . strtoupper($name) . "%' OR UPPER(phone)  LIKE '" . strtoupper($name) . "%') LIMIT 6");
            $result = $query->result_array();
            echo '<ol>';
            $i = 1;
            foreach ($result as $row) {

                echo "<li onClick=\"selectCustomer('" . $row['id'] . "','" . $row['name'] . " ','" . $row['address'] . "','" . $row['city'] . "','" . $row['phone'] . "','" . $row['email'] . "','" . amountFormat_general($row['discount_c']) . "','" . $row['iddoc'] . "')\"><span>$i</span><p>" . $row['name'] . " &nbsp; &nbsp  " . $row['phone'] . "</p></li>";
                $i++;
            }
            echo '</ol>';
        }

    }

    public function party_search()
    {
        $result = array();
        $out = array();
        $tbl = 'jsoft_customers';
        $name = $this->input->get('keyword', true);

        $ty = $this->input->get('ty', true);
        if ($ty) $tbl = 'jsoft_supplier';
        $whr = '';

        if ($this->aauth->get_user()->loc) {
            $whr = ' (loc=' . $this->aauth->get_user()->loc . ' OR loc=0) AND ';
            if (!BDATA) $whr = ' (loc=' . $this->aauth->get_user()->loc . ' ) AND ';
        } elseif (!BDATA) {
            $whr = ' (loc=0) AND ';
        }
        if ($name) {
            $query = $this->db->query("SELECT id,name,address,city,phone,email FROM $tbl  WHERE $whr (UPPER(name)  LIKE '%" . strtoupper($name) . "%' OR UPPER(phone)  LIKE '" . strtoupper($name) . "%') LIMIT 6");
            $result = $query->result_array();
            echo '<ol>';
            $i = 1;
            foreach ($result as $row) {
                echo "<li onClick=\"selectCustomer('" . $row['id'] . "','" . $row['name'] . " ','" . $row['address'] . "','" . $row['city'] . "','" . $row['phone'] . "','" . $row['email'] . "')\"><span>$i</span><p>" . $row['name'] . " &nbsp; &nbsp  " . $row['phone'] . "</p></li>";
                $i++;
            }
            echo '</ol>';
        }
    }

    public function pos_c_search()
    {
        $result = array();
        $out = array();
        $name = $this->input->get('keyword', true);
        $whr = '';
        if ($this->aauth->get_user()->loc) {
            $whr = ' (loc=' . $this->aauth->get_user()->loc . ' OR loc=0) AND ';
            if (!BDATA) $whr = ' (loc=' . $this->aauth->get_user()->loc . ' ) AND ';
        } elseif (!BDATA) {
            $whr = ' (loc=0) AND ';
        }
        if ($name) {
            $query = $this->db->query("SELECT id,name,phone,numdoc,iddoc,discount_c, address, company, phone, email, country, region, city FROM jsoft_customers WHERE $whr (UPPER(name)  LIKE '%" . strtoupper($name) . "%' OR UPPER(numdoc)  LIKE '" . strtoupper($name) . "%') LIMIT 6");
            $result = $query->result_array();
            echo '<ol>';
            $i = 1;
            foreach ($result as $row) {
                echo "<li onClick=\"PselectCustomer('" . $row['id'] . "', '" . $row['numdoc'] . "', '" . $row['address'] . "', '" . $row['company'] . "', '" . $row['phone'] . "', '" . $row['email'] . "', '" . $row['country'] . "', '" . $row['region'] . "', '" . $row['city'] . "', '" . $row['name'] . "','" . amountFormat_general($row['discount_c']) . "','" . $row['iddoc'] . "')\"><span>$i</span><p>" . $row['numdoc'] . " &nbsp; &nbsp  " . $row['name'] . "</p></li>";
                $i++;
            }
            echo '</ol>';
        }
    }

    public function supplier()
    {
        $result = array();
        $out = array();
        $name = $this->input->get('keyword', true);

        $whr = '';
        if ($this->aauth->get_user()->loc) {
            $whr = ' (loc=' . $this->aauth->get_user()->loc . ' OR loc=0) AND ';
            if (!BDATA) $whr = ' (loc=' . $this->aauth->get_user()->loc . ' ) AND ';
        } elseif (!BDATA) {
            $whr = ' (loc=0) AND ';
        }
        if ($name) {
            $query = $this->db->query("SELECT id,name,address,city,phone,email FROM jsoft_supplier WHERE $whr (UPPER(name)  LIKE '%" . strtoupper($name) . "%' OR UPPER(ruc)  LIKE '" . strtoupper($name) . "%') LIMIT 6");
            $result = $query->result_array();
            echo '<ol>';
            $i = 1;
            foreach ($result as $row) {
                echo "<li onClick=\"selectSupplier('" . $row['id'] . "','" . $row['name'] . " ','" . $row['address'] . "','" . $row['city'] . "','" . $row['phone'] . "','" . $row['email'] . "')\"><span>$i</span><p>" . $row['name'] . " &nbsp; &nbsp  " . $row['phone'] . "</p></li>";
                $i++;
            }
            echo '</ol>';
        }
    }

    public function pos_search()
    {

        $out = '';
        $this->load->model('plugins_model', 'plugins');
        $billing_settings = $this->plugins->universal_api(67);
        
        $name = $this->input->post('name', true);
        $cid = $this->input->post('cid', true);
        $wid = $this->input->post('wid', true);
        $qw = '';
        if ($wid > 0) {
            $qw .= "(v_jsoft_productos.warehouse='$wid') AND ";
        }
        if ($billing_settings['key2']) $qw .= "(v_jsoft_productos.expiry IS NULL OR DATE (v_jsoft_productos.expiry)<" . date('Y-m-d') . ") AND ";
        if ($cid > 0) {
            $qw .= "(v_jsoft_productos.pcat='$cid') AND ";
        }
        $join = '';
        if ($this->aauth->get_user()->loc) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=v_jsoft_productos.warehouse';
            if (BDATA) {
                $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' OR jsoft_warehouse.loc=0) AND '; 
        
                
            }else {
                $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' ) AND ';
                
        }
        } elseif (!BDATA) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=v_jsoft_productos.warehouse';
            $qw .= '(jsoft_warehouse.loc=0) AND ';
        }

        $e = '';
        if ($billing_settings['key1'] == 1) {
            $e .= ',jsoft_product_serials.serial';
            $join .= 'LEFT JOIN jsoft_product_serials ON jsoft_product_serials.product_id=v_jsoft_productos.pid ';
            $qw .= '(jsoft_product_serials.status=0) AND  ';
        }

        $bar = '';
        if (is_numeric($name)) {
            $b = array('-', '-', '-');
            $c = array(3, 4, 11);
            $barcode = $name;
            for ($i = count($c) - 1; $i >= 0; $i--) {
                $barcode = substr_replace($barcode, $b[$i], $c[$i], 0);
            }
            
            
            $bar = " OR (v_jsoft_productos.barcode LIKE '" . (substr($barcode, 0, -1)) . "%' OR v_jsoft_productos.barcode LIKE '%" . (substr($name, 0, -1)) . "%')";
        }
        if ($billing_settings['key1'] == 2) {

            $query = "SELECT jsoft_products.*,jsoft_product_serials.serial FROM jsoft_product_serials  LEFT JOIN jsoft_products  ON jsoft_products.pid=jsoft_product_serials.product_id $join WHERE " . $qw . "jsoft_product_serials.serial LIKE '" . strtoupper($name) . "%'  AND (jsoft_products.qty>0 OR jsoft_products.qty IS NULL) LIMIT 24";


        } else {
            $query = "SELECT * $e FROM v_jsoft_productos $join WHERE " . $qw . "(UPPER(v_jsoft_productos.producto) LIKE '%" . strtoupper($name) . "%' $bar OR v_jsoft_productos.product_code LIKE '%" . strtoupper($name) . "%') AND (v_jsoft_productos.qty>0 OR (v_jsoft_productos.qty = 0 AND v_jsoft_productos.tipo = 'S')) LIMIT 24";

        }

        $query = $this->db->query($query);

        $result = $query->result_array();
        $i = 0;
        echo '<div class="row match-height">';
        foreach ($result as $row) {
            if($row['qty'] > $row['alert']){
                $bg = 'bg-primary';
                $alert = '';
            }else{
                $bg = 'bg-danger';
                $alert = '<span class="topbar card-notify-badge rounded-pill parpadea"><b class="badge bg-info"> Stock Bajo </b></span>';
            }
            if ($row['tipo'] == 'P') {
                $cant = '<span class="topbar2"><b class="badge '.$bg.'"> '.amountFormat_general($row['qty']).' '.$row['unit'].' </b></span>';
                $prec = 'Unit: '.amountFormat_general($row['product_price']);
                $precmin = amountFormat_general($row['precio_min']);
                $preccom = '<span class=""><b class="badge bg-warning">Compra: '.amountFormat_general($row['fproduct_price']).' </b></span>';
            }else{
                $cant = '';
                $prec = 'Unit: '.amountFormat_general($row['product_price']);
                $precmin = amountFormat_general($row['precio_min']);
                $preccom = '';
            }

            
            
            $out .= ' <div class="col-lg-3 col-md-6 col-sm-6">
			<figure class="card2 card-product-grid select_pos_item btn btn-outline-light-blue" id="posp' . $i . '"  data-name="' . $row['producto'] . '" data-prodesc="' . $row['product_des'] . '" data-color="' . $row['color'] . '" data-talla="' . $row['talla'] . '" data-marca="' . $row['marca'] . '" data-price="' . amountExchange_s($row['product_price'], 0, $this->aauth->get_user()->loc) . '" data-preciomin="' . amountExchange_s($row['precio_min'], 0, $this->aauth->get_user()->loc) . '" data-tax="' . amountFormat_general($row['taxrate']) . '"  data-discount="' . amountFormat_general($row['disrate']) . '" data-icbper="' . amountFormat_general($row['icbper']) . '"   data-pcode="' . $row['product_code'] . '" data-sunat="' . $row['codigosunat'] . '"   data-pid="' . $row['pid'] . '"  data-stock="' . amountFormat_general($row['qty']) . '" data-tipo="' . $row['tipo'] . '" data-unit="' . $row['unit'] . '" data-serial="' . @$row['serial'] . '">
				<a href="javascript:void(0);" class="img-wrap"> 
                '.$alert.$cant.'
                
                
					<img src="' . base_url('userfiles/product/' . $row['image']) . '"> 
				</a>
				<figcaption class="info-wrap">
                <a href="javascript:void(0)" class="title text-truncate">' . $row['producto'].'</a>
					<small class="text-muted">Min: '.$precmin.'</small>
					<div class="price-wrap">
						<span class="price badge bg-success">'.amountExchange($row['product_price'], null, 0).'</span>'.$preccom.'
					</div> <!-- price-wrap.// -->
				</figcaption>
			</figure>
		</div>';

            $i++;
            //   if ($i % 4 == 0) $out .= '</div><div class="row">';
        }

        echo $out;

    }

    public function v2_pos_search()
    {

        $out = '';
        $this->load->model('plugins_model', 'plugins');
        $billing_settings = $this->plugins->universal_api(67);
        $name = $this->input->post('name', true);
        $cid = $this->input->post('cid', true);
        $wid = $this->input->post('wid', true);

        $qw = '';

        if ($wid > 0) {
            $qw .= "(jsoft_products.warehouse='$wid') AND ";
        }
        if ($billing_settings['key2']) $qw .= "(jsoft_products.expiry IS NULL OR DATE (jsoft_products.expiry)<" . date('Y-m-d') . ") AND ";
        if ($cid > 0) {
            $qw .= "(jsoft_products.pcat='$cid') AND ";
        }
        $join = '';

        if ($this->aauth->get_user()->loc) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=jsoft_products.warehouse';
            if (BDATA) $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' OR jsoft_warehouse.loc=0) AND '; else $qw .= '(jsoft_warehouse.loc=' . $this->aauth->get_user()->loc . ' ) AND ';
        } elseif (!BDATA) {
            $join = 'LEFT JOIN jsoft_warehouse ON jsoft_warehouse.id=jsoft_products.warehouse';
            $qw .= '(jsoft_warehouse.loc=0) AND ';
        }

        $e = '';
        if ($billing_settings['key1'] == 1) {
            $e .= ',jsoft_product_serials.serial';
            $join .= 'LEFT JOIN jsoft_product_serials ON jsoft_product_serials.product_id=jsoft_products.pid ';
            $qw .= '(jsoft_product_serials.status=0) AND  ';
        }

        $bar = '';

        if (is_numeric($name)) {
            $b = array('-', '-', '-');
            $c = array(3, 4, 11);
            $barcode = $name;
            for ($i = count($c) - 1; $i >= 0; $i--) {
                $barcode = substr_replace($barcode, $b[$i], $c[$i], 0);
            }
            //    echo(substr($barcode, 0, -1));
            $bar = " OR (jsoft_products.barcode LIKE '" . (substr($barcode, 0, -1)) . "%' OR jsoft_products.barcode LIKE '" . $name . "%')";
            //  $query = "SELECT jsoft_products.* FROM jsoft_products $join WHERE " . $qw . " $bar AND (jsoft_products.qty>0) LIMIT 16";
        }
        if ($billing_settings['key1'] == 2) {

            $query = "SELECT jsoft_products.*,jsoft_product_serials.serial FROM jsoft_product_serials  LEFT JOIN jsoft_products  ON jsoft_products.pid=jsoft_product_serials.product_id $join WHERE " . $qw . "jsoft_product_serials.serial LIKE '" . strtoupper($name) . "%'  AND (jsoft_products.qty>0 OR jsoft_products.qty IS NULL) LIMIT 18";

        } else {
            $query = "SELECT jsoft_products.* $e FROM jsoft_products $join WHERE " . $qw . "(UPPER(jsoft_products.product_name) LIKE '%" . strtoupper($name) . "%' $bar OR jsoft_products.product_code LIKE '" . strtoupper($name) . "%') AND (jsoft_products.qty>0 OR jsoft_products.qty IS NULL) ORDER BY jsoft_products.product_name LIMIT 18";
        }

        $query = $this->db->query($query);
        $result = $query->result_array();
        $i = 0;
        echo '<div class="row match-height">';
        foreach ($result as $row) {

            $out .= '    <div class="col-2 border mb-1"  ><div class=" rounded" >
                                 <a  id="posp' . $i . '"  class="v2_select_pos_item round"   data-name="' . $row['product_name'] . '"  data-price="' . amountExchange_s($row['product_price'], 0, $this->aauth->get_user()->loc) . '"  data-tax="' . amountFormat_general($row['taxrate']) . '"  data-discount="' . amountFormat_general($row['disrate']) . '" data-pcode="' . $row['product_code'] . '"   data-pid="' . $row['pid'] . '"  data-stock="' . amountFormat_general($row['qty']) . '" data-unit="' . $row['unit'] . '" data-serial="' . @$row['serial'] . '">
                                        <img class="round"
                                             src="' . base_url('userfiles/product/' . $row['image']) . '"  style="max-height: 100%;max-width: 100%">
                                        <div class="text-center" style="margin-top: 4px;">
                                       
                                            <small style="white-space: pre-wrap;">' . $row['product_name'] . '</small>                                            
                                        </div></a>                                 
                                </div></div>';
            $i++;

        }

        echo $out;
    }
}