<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Servicios extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library("Aauth");
        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        if (!$this->aauth->premission(2)) {

            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');

        }
        $this->load->model('servicios_model', 'servicios');
        $this->load->model('categories_model');
        $this->load->library("Custom");
        $this->li_a = 'stock';
        $this->load->library("Registerlog");

    }

    public function index()
    {
        $head['title'] = "Servicios";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('products/servicios');
        $this->load->view('fixed/footer');
    }

    public function list_servicios()
    {
        $catid = $this->input->get('id');
        $sub = $this->input->get('sub');

        if ($catid > 0) {
            $list = $this->servicios->get_datatables($catid, '', $sub);
        } else {
            $list = $this->servicios->get_datatables();
        }
        
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $prd) {
            $no++;
            $row = array();
            $row[] = $no;
            $pid = $prd->pid;
            $row[] = '<a href="#" data-object-id="' . $pid . '" class="view-object"><span class="avatar-lg align-baseline"><img src="' . base_url() . 'userfiles/product/thumbnail/' . $prd->image . '" ></span>&nbsp;' . $prd->product_name . ' - ' . $prd->color.'</a>';
            
            $row[] = $prd->c_title;
            $row[] = amountExchange($prd->product_price, 0, $this->aauth->get_user()->loc);
            $row[] = '<a href="#" data-object-id="' . $pid . '" class="btn btn-success  btn-sm  view-object"><span class="fa fa-eye"></span> ' . $this->lang->line('View') . '</a> 

                                         <a class="btn btn-pink  btn-sm" href="' . base_url() . 'products/report_product?id=' . $pid . '" target="_blank"> <span class="fa fa-pie-chart"></span> ' . $this->lang->line('Reports') . '</a> <div class="btn-group">
                                    <button type="button" class="btn btn btn-primary dropdown-toggle   btn-sm" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> <i class="fa fa-cog"></i>  </button>
                                    <div class="dropdown-menu">
&nbsp;<a href="' . base_url() . 'products/edit?id=' . $pid . '"  class="btn btn-purple btn-sm"><span class="fa fa-edit"></span>' . $this->lang->line('Edit') . '</a><div class="dropdown-divider"></div>&nbsp;<a href="#" data-object-id="' . $pid . '" class="btn btn-danger btn-sm  delete-object"><span class="fa fa-trash"></span>' . $this->lang->line('Delete') . '</a>
                                    </div>
                                </div>';
            $data[] = $row;
        }
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->servicios->count_all($catid, '', $sub),
            "recordsFiltered" => $this->servicios->count_filtered($catid, '', $sub),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }
    

    public function delete_i()
    {
        if ($this->aauth->premission(11)) {
            $id = $this->input->post('deleteid');
            if ($id) {
                $this->db->delete('jsoft_products', array('pid' => $id));
                $this->db->delete('jsoft_products', array('sub' => $id, 'merge' => 1));
                $this->db->delete('jsoft_movers', array('d_type' => 1, 'rid1' => $id));
                $this->db->set('merge', 0);
                $this->db->where('sub', $id);
                $this->db->update('jsoft_products');
                echo json_encode(array('status' => 'Success', 'message' => $this->lang->line('DELETED')));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => $this->lang->line('ERROR')));
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
        }
    }

    

    

    public function prd_stats()
    {
        $this->servicios->prd_stats();
    }

    

   
    

    public function view_over()
    {
        $pid = $this->input->post('id');
        $this->db->select('jsoft_products.*,jsoft_warehouse.title');
        $this->db->from('jsoft_products');
        $this->db->where('jsoft_products.pid', $pid);
        $this->db->join('jsoft_warehouse', 'jsoft_warehouse.id = jsoft_products.warehouse');
        if ($this->aauth->get_user()->loc) {
            $this->db->group_start();
            $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);
            if (BDATA) $this->db->or_where('jsoft_warehouse.loc', 0);
            $this->db->group_end();
        } elseif (!BDATA) {
            $this->db->where('jsoft_warehouse.loc', 0);
        }

        $query = $this->db->get();
        $data['product'] = $query->row_array();

        $this->db->select('jsoft_products.*,jsoft_warehouse.title');
        $this->db->from('jsoft_products');
        $this->db->join('jsoft_warehouse', 'jsoft_warehouse.id = jsoft_products.warehouse');
        if ($this->aauth->get_user()->loc) {
            $this->db->group_start();
            $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);
            if (BDATA) $this->db->or_where('jsoft_warehouse.loc', 0);
            $this->db->group_end();
        } elseif (!BDATA) {
            $this->db->where('jsoft_warehouse.loc', 0);
        }
        $this->db->where('jsoft_products.merge', 1);
        $this->db->where('jsoft_products.sub', $pid);
        $query = $this->db->get();
        $data['product_variations'] = $query->result_array();

        $this->db->select('jsoft_products.*,jsoft_warehouse.title');
        $this->db->from('jsoft_products');
        $this->db->join('jsoft_warehouse', 'jsoft_warehouse.id = jsoft_products.warehouse');
        if ($this->aauth->get_user()->loc) {
            $this->db->group_start();
            $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);
            if (BDATA) $this->db->or_where('jsoft_warehouse.loc', 0);
            $this->db->group_end();
        } elseif (!BDATA) {
            $this->db->where('jsoft_warehouse.loc', 0);
        }
        $this->db->where('jsoft_products.sub', $pid);
        $this->db->where('jsoft_products.merge', 2);
        $query = $this->db->get();
        $data['product_warehouse'] = $query->result_array();

        $this->load->view('products/view-over', $data);

    }



}