<?php

defined('BASEPATH') or exit('No direct script access allowed');
error_reporting(E_ALL);
ini_set('display_errors', '1');

use Greenter\Model\Sale\Invoice;
use Greenter\Model\Sale\SaleDetail;
use Greenter\Model\Sale\Legend;
use Greenter\Ws\Services\SunatEndpoints;
use Greenter\Model\Client\Client;
use Greenter\Model\Company\Address;
use Greenter\Model\Company\Company;
use Greenter\Model\Voided\VoidedDetail;
use Greenter\Model\Voided\Voided;
use Greenter\Model\Sale\Note;
use Greenter\Model\Summary\Summary;
use Greenter\Model\Summary\SummaryDetail;
use Greenter\Model\Sale\Charge;

require_once APPPATH . 'third_party/vendor/autoload.php';
require_once APPPATH . 'third_party/qrcode/vendor/autoload.php';
require 'vendor/autoload.php';

class Stockreturn extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Stockreturn_model', 'stockreturn');
        $this->load->library("Aauth");
        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        $this->li_a = 'stock';
        $this->load->library("Registerlog");
    }

    //create invoice
    public function create($param = "", $param2 = "") {
        if (!$this->aauth->premission(2)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $this->load->library("Common");
        $this->load->model('plugins_model', 'plugins');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['currency'] = $this->stockreturn->currencies();
        $data['taxlist'] = $this->common->taxlist($this->config->item('tax'));
        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['lastinvoice'] = $this->stockreturn->lastpurchase($param, $param2);
        $data['terms'] = $this->stockreturn->billingterms();
        $head['title'] = "Nueva nota de crédito";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->stockreturn->warehouses();
        $data['taxdetails'] = $this->common->taxdetail();
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/newinvoice', $data);
        $this->load->view('fixed/footer');
    }

    public function create_client() {
        if (!$this->aauth->premission(2)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $this->load->library("Common");
        $this->load->model('plugins_model', 'plugins');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['currency'] = $this->stockreturn->currencies();
        $data['taxlist'] = $this->common->taxlist($this->config->item('tax'));
        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['lastinvoice'] = $this->stockreturn->lastpurchase();
        $data['terms'] = $this->stockreturn->billingterms();
        $head['title'] = "Nueva devolución de stock";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->stockreturn->warehouses();
        $data['taxdetails'] = $this->common->taxdetail();
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/c_newinvoice', $data);
        $this->load->view('fixed/footer');
    }

    public function create_note($param = "", $param2 = "") {
        if (!$this->aauth->premission(1)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $this->load->library("Common");
        $data['taxlist'] = $this->common->taxlist($this->config->item('tax'));
        $this->load->model('customers_model', 'customers');
        $this->load->model('plugins_model', 'plugins');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['currency'] = $this->stockreturn->currencies();
        $data['customergrouplist'] = $this->customers->group_list();
        $data['terms'] = $this->stockreturn->billingterms();
        $head['title'] = "Nueva Nota de Crédito";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->stockreturn->warehouses();
        $data['taxdetails'] = $this->common->taxdetail();
        $data['serie'] = $this->stockreturn->cargarserie($param);
        $data['ref'] = $this->input->get('ref');
        $data['tipop'] = $this->stockreturn->listartipooperacion();
        $data['tp'] = $this->stockreturn->listartipoprecio();
        $data['ta'] = $this->stockreturn->listartipoafectacion();
        $data['productos'] = $this->stockreturn->listar_productos($param2);
        $data['comprobante'] = $this->stockreturn->listar_comprobantes($param2);
        $data['cliente'] = $this->stockreturn->listar_cliente($param2);
        $data['tpcomp'] = $param;
        $data['idcomp'] = $param2;
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/note_newinvoice', $data);
        $this->load->view('fixed/footer');
    }

    public function correlativo($param = "", $param2 = "") {

        $this->load->library("Common");
        $correlativo = $this->stockreturn->lastpurchase($param, $param2);
        echo json_encode($correlativo);
    }

    //edit invoice
    public function edit() {
        if (!$this->aauth->premission(2)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $tid = intval($this->input->get('id'));
        $data['id'] = $tid;
        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['terms'] = $this->stockreturn->billingterms();
        $data['invoice'] = $this->stockreturn->purchase_details($tid);
        $data['products'] = $this->stockreturn->purchase_products($tid);
        $head['title'] = "Orden de devolución de stock " . $data['invoice']['iid'];
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->stockreturn->warehouses();
        $this->load->library("Common");
        $data['taxlist'] = $this->common->taxlist_edit($data['invoice']['taxstatus']);
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/edit', $data);
        $this->load->view('fixed/footer');
    }

    public function edit_c() {
        if (!$this->aauth->premission(2)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $tid = intval($this->input->get('id'));
        $data['id'] = $tid;
        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['terms'] = $this->stockreturn->billingterms();
        $data['invoice'] = $this->stockreturn->purchase_details($tid);
        $data['products'] = $this->stockreturn->purchase_products($tid);

        $head['title'] = "Orden de devolución de stock " . $data['invoice']['iid'];
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->stockreturn->warehouses();
        $this->load->library("Common");
        $data['taxlist'] = $this->common->taxlist_edit($data['invoice']['taxstatus']);
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/c_edit', $data);
        $this->load->view('fixed/footer');
    }

    public function edit_note() {
        if (!$this->aauth->premission(1)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $tid = intval($this->input->get('id'));
        $data['id'] = $tid;
        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['terms'] = $this->stockreturn->billingterms();
        $data['invoice'] = $this->stockreturn->purchase_details($tid);
        $data['products'] = $this->stockreturn->purchase_products($tid);
        ;
        $head['title'] = "Nota de crédito " . $data['invoice']['iid'];
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->stockreturn->warehouses();
        $this->load->library("Common");
        $data['taxlist'] = $this->common->taxlist_edit($data['invoice']['taxstatus']);
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/note_edit', $data);
        $this->load->view('fixed/footer');
    }

    //invoices list
    public function index() {
        if (!$this->aauth->premission(2)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $head['title'] = "Gestionar órdenes de devolución de stock";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/invoices');
        $this->load->view('fixed/footer');
    }

    public function customer() {
        if (!$this->aauth->premission(2)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $head['title'] = "Gestionar órdenes de devolución de stock";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/invoices_client');
        $this->load->view('fixed/footer');
    }

    public function creditnotes() {
        if (!$this->aauth->premission(1)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $head['title'] = "Administrar Notas de Crédito";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/creditnotes_client');
        $this->load->view('fixed/footer');
    }

    //action
    public function action() {
        $this->load->helper('convertir');
        $currency = $this->input->post('mcurrency');
        $customer_id = $this->input->post('customer_id');
        $person_type = $this->input->post('person_type');
        $new_u = 'create';
        if ($person_type) {
            $new_u = 'create_client';
            if (!$this->aauth->premission(2)) {
                exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
            }
        }
        if ($person_type == 2) {
            $new_u = 'create_note';
            if (!$this->aauth->premission(1)) {
                exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
            }
        }
        $invocieno = $this->input->post('invocieno');
        $invoicedate = $this->input->post('invoicedate');
        $invocieduedate = $this->input->post('invocieduedate');
        $refein = $this->input->post('refe');

        $tpop = $this->input->post('tipop');
        $idmotivo = $this->input->post('mtanulacion');
        $iddoc = $this->input->post('idtipodoc');
        $idserie = $this->input->post('serie');
        $idtipocomprobante = $this->input->post('tpcomp');
        $idcomprobante = $this->input->post('idcomp');
        $notes = $this->input->post('notes', true);
        $tax = $this->input->post('tax_handle');
        $ship_taxtype = $this->input->post('ship_taxtype');
        $total_tax = 0;
        $total_discount = 0;
        $discountFormat = $this->input->post('discountFormat');
        $pterms = $this->input->post('pterms');
        $i = 0;
        if ($discountFormat == '0') {
            $discstatus = 0;
        } else {
            $discstatus = 1;
        }
        $subtotal = rev_amountExchange_s($this->input->post('subtotal'), $currency, $this->aauth->get_user()->loc);
        $shipping = rev_amountExchange_s($this->input->post('shipping'), $currency, $this->aauth->get_user()->loc);
        $shipping_tax = rev_amountExchange_s($this->input->post('ship_tax'), $currency, $this->aauth->get_user()->loc);
        if ($ship_taxtype == 'incl')
            $shipping = $shipping - $shipping_tax;
        $refer = $this->input->post('refer');
        $total = rev_amountExchange_s($this->input->post('total'), $currency, $this->aauth->get_user()->loc);
        if ($customer_id == 0) {
            echo json_encode(array('status' => 'Error', 'message' =>
                "¡Agregue un nuevo cliente o busque uno ya registrado!"));
            exit;
        } else {
            $this->db->select('*');
            $this->db->from('jsoft_customers');
            $this->db->where('id', $customer_id);
            $query = $this->db->get();
            $result_cus = $query->row_array();
        }
        $this->db->trans_start();
        //products
        $transok = true;
        //Invoice Data
        $bill_date = datefordatabase($invoicedate);
        $bill_due_date = datefordatabase($invocieduedate);
        $invoicen = $invocieno;
        if (!$currency)
            $currency = 0;
        $data = array('idserie' => $idserie, 'tid' => $invocieno, 'tipocomprobante' => $idtipocomprobante, 'iddoc' => $iddoc, 'motivo' => $idmotivo, 'invoicedate' => $bill_date, 'invoiceduedate' => $bill_due_date, 'subtotal' => $subtotal, 'shipping' => $shipping, 'ship_tax' => $shipping_tax, 'ship_tax_type' => $ship_taxtype, 'total' => $total, 'notes' => $notes, 'idtipooperacion' => $tpop, 'csd' => $customer_id, 'eid' => $this->aauth->get_user()->id, 'taxstatus' => $tax, 'discstatus' => $discstatus, 'format_discount' => $discountFormat, 'refer' => $refer, 'term' => $pterms, 'loc' => $this->aauth->get_user()->loc, 'i_class' => $person_type, 'multi' => $currency, 'idcomprobante' => $idcomprobante);

        if ($this->db->insert('jsoft_stock_r', $data)) {
            $invocieno = $this->db->insert_id();
            $pid = $this->input->post('pid');
            $productlist = array();
            $prodindex = 0;
            $itc = 0;
            $product_id = $this->input->post('pid');
            $product_name1 = $this->input->post('product_name', true);
            $product_qty = $this->input->post('product_qty');
            $product_price = $this->input->post('product_price');
            $product_tax = $this->input->post('product_tax');
            $product_discount = $this->input->post('product_discount');
            $product_subtotal = $this->input->post('product_subtotal');
            $ptotal_tax = $this->input->post('taxa');
            $ptotal_disc = $this->input->post('disca');

            $tipo_precio = $this->input->post('product_tipoprecio');
            $tipo_afectacion = $this->input->post('product_tipoafectacion');

            $product_des = $this->input->post('product_description', true);
            $product_icbper = $this->input->post('product_icbper');
            $product_unit = $this->input->post('unit');
            $product_hsn = $this->input->post('hsn');
            $icbper = $this->input->post('icbper');
            if (is_array($pid)) {
                foreach ($pid as $key => $value) {
                    $this->db->select('*');
                    $this->db->from('jsoft_products');
                    $this->db->where('pid', $product_id[$key]);
                    $queryp = $this->db->get();
                    $result_p = $queryp->row_array();

                    if(empty($result_p['fproduct_price']) || $result_p['fproduct_price'] == null){
                        $result_p['fproduct_price'] = 0;
                    }

                    $total_discount += numberClean(@$ptotal_disc[$key]);
                    $total_tax += numberClean($ptotal_tax[$key]);
                    $data = array(
                        'idserie' => $idserie,
                        'tid' => $invocieno,
                        'tipocomprobante' => $idtipocomprobante,
                        'idtipoprecio' => $tipo_precio[$key],
                        'idtipoafectacion' => $tipo_afectacion[$key],
                        'pid' => $product_id[$key],
                        'product' => $product_name1[$key],
                        'code' => $product_hsn[$key],
                        'qty' => numberClean($product_qty[$key]),
                        'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                        'tax' => numberClean($product_tax[$key]),
                        'discount' => numberClean($product_discount[$key]),
                        'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                        'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                        'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                        'product_des' => $product_des[$key],
                        'unit' => $product_unit[$key],
                        'valorunit' => $result_p['fproduct_price'],
                        'icbper' => $product_icbper[$key],
                    );
                    $productlist[$prodindex] = $data;
                    $i++;
                    $prodindex++;
                    $amt = numberClean($product_qty[$key]);
                    if ($product_id[$key] > 0) {
                        if ($this->input->post('update_stock') == 'yes') {

                            if ($person_type) {
                                $this->db->set('qty', "qty+$amt", FALSE);
                            } else {
                                $this->db->set('qty', "qty-$amt", FALSE);
                            }

                            $this->db->where('pid', $product_id[$key]);
                            $this->db->update('jsoft_products');
                        }
                        $itc += $amt;
                    }
                }
            }
            if ($prodindex > 0) {
                $this->db->insert_batch('jsoft_stock_r_items', $productlist);
                $this->db->set(array('discount' => rev_amountExchange_s(amountFormat_general($total_discount), $currency, $this->aauth->get_user()->loc), 'tax' => rev_amountExchange_s(amountFormat_general($total_tax), $currency, $this->aauth->get_user()->loc), 'items' => $itc));
                $this->db->where('id', $invocieno);
                $this->db->update('jsoft_stock_r');
                $this->db->set(array('refer' => $refein . '-' . $invocieno));
                $this->db->where('id', $idcomprobante);
                $this->db->update('jsoft_invoices');
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                    "Elija un producto de la lista. Vaya a la sección Administrador de artículos si no ha agregado los productos."));
                $transok = false;
            }

            $this->db->select('jsoft_invoices.pmethod, jsoft_stock_r.eid, jsoft_stock_r.total');
            $this->db->from('jsoft_stock_r');
            $this->db->join('jsoft_invoices', 'jsoft_invoices.id = jsoft_stock_r.idcomprobante');
            $this->db->where('jsoft_stock_r.id', $invocieno);
            $query = $this->db->get();
            $resultst = $query->row_array();

            switch ($resultst['pmethod']) {
                case 'Efectivo':
                    $r_amt1 = $resultst['total'];
                    $r_amt2 = 0;
                    $r_amt3 = 0;
                    $r_amt4 = 0;
                    $r_amt5 = 0;
                    break;
                case 'Pase de Trajeta (POS)':
                    $r_amt1 = 0;
                    $r_amt2 = $resultst['total'];
                    $r_amt3 = 0;
                    $r_amt4 = 0;
                    $r_amt5 = 0;
                    break;
                case 'Transferencia Bancaria':
                    $r_amt1 = 0;
                    $r_amt2 = 0;
                    $r_amt3 = $resultst['total'];
                    $r_amt4 = 0;
                    $r_amt5 = 0;
                    break;
                case 'yape':
                    $r_amt1 = 0;
                    $r_amt2 = 0;
                    $r_amt3 = 0;
                    $r_amt4 = $resultst['total'];
                    $r_amt5 = 0;
                    break;
                case 'plin':
                    $r_amt1 = 0;
                    $r_amt2 = 0;
                    $r_amt3 = 0;
                    $r_amt4 = 0;
                    $r_amt5 = $resultst['total'];
                    break;
            }
            
                
                $this->registerlog->updateex($resultst['eid'], $r_amt1, $r_amt2, $r_amt3, $r_amt4, $r_amt5, 0, 0);
            




            if (is_array($pid)) {
                foreach ($pid as $key => $value) {

                    $this->db->select('pid,COALESCE(SUM(subtotal), 0) as subtotal');
                    $this->db->from('jsoft_invoice_items');
                    $this->db->where('idtipoafectacion', 10);
                    $this->db->where('tid', $invocieno);
                    $queryafect = $this->db->get()->result()[0]->subtotal;
                }
            }

            if (is_array($pid)) {
                foreach ($pid as $key => $value) {

                    $this->db->select('pid,COALESCE(SUM(subtotal), 0) as subtotal');
                    $this->db->from('jsoft_invoice_items');
                    $this->db->where('idtipoafectacion', 20);
                    $this->db->where('tid', $invocieno);
                    $queryafec = $this->db->get()->result()[0]->subtotal;
                }
            }

            $this->db->select('*');
            $this->db->from('tipocomprobante');
            $this->db->where('idtipocomprobante', $idtipocomprobante);
            $query = $this->db->get();
            $result_comp = $query->row_array();

            $this->db->select('*');
            $this->db->from('serie');
            $this->db->where('id', $idserie);
            $queryserie = $this->db->get();
            $result_serie = $queryserie->row_array();

            $loc = location($this->aauth->get_user()->loc);

            $cur = currency($this->aauth->get_user()->loc);

            if ($cur == 'S/') {
                $mon = 'PEN';
            } else {
                $mon = 'USD';
            }
            $totaletras = num_to_letras($total, $mon);
            $rpta = "";
            $linkxml = "";



            if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {
                $util = Util::getInstance();
// Cliente
                $client = new Client();
                $client->setTipoDoc($iddoc)
                        ->setNumDoc($result_cus['numdoc'])
                        ->setRznSocial($result_cus['name'])
                        ->setAddress((new Address())
                                ->setDireccion($result_cus['address']))
                        ->setEmail($result_cus['email'])
                        ->setTelephone($result_cus['phone']);
// Venta

                $note = new Note();
                $note
                        ->setUblVersion('2.1')
                        ->setTipoDoc($result_comp['numtipo_comprobante'])
                        ->setSerie($result_serie['serie'])
                        ->setCorrelativo($invoicen)
                        ->setFechaEmision(new DateTime())
                        ->setTipDocAfectado('03') // Tipo Doc: Factura
                        ->setNumDocfectado($refer) // Factura: Serie-Correlativo
                        ->setCodMotivo($idmotivo) // Catalogo. 09
                        ->setDesMotivo($notes)
                        ->setTipoMoneda($mon)
//                    ->setGuias([/* Guias (Opcional) */
//                        (new Document())
//                        ->setTipoDoc('09')
//                        ->setNroDoc('0001-213')
//                    ])
                        ->setCompany((new Company())
                                ->setRuc($loc['ruc'])
                                ->setNombreComercial($loc['ncomercial'])
                                ->setRazonSocial($loc['cname'])
                                ->setAddress((new Address())
                                        ->setUbigueo($loc['ubigeo'])
                                        ->setDistrito($loc['city'])
                                        ->setProvincia($loc['region'])
                                        ->setDepartamento($loc['country'])
                                        ->setUrbanizacion('NONE')
                                        ->setCodLocal($loc['codlocal'])
                                        ->setDireccion($loc['address']))
                                ->setEmail($loc['email'])
                                ->setTelephone($loc['phone']))
                        ->setClient($client)
                        ->setMtoOperGravadas($queryafect)
                        ->setMtoOperExoneradas($queryafec)
                        ->setMtoIGV($total_tax)
                        ->setIcbper($icbper)
                        ->setTotalImpuestos($total_tax + $icbper)
                        ->setMtoImpVenta($total);

                $detalles = [];
                foreach ($productlist as $detail) {
                    $items = new SaleDetail();
                    $items->setCodProducto($detail['code'])
                            ->setUnidad($detail['unit'])
                            ->setCantidad($detail['qty'])
                            ->setDescripcion($detail['product'])
                            ->setMtoValorUnitario($detail['valorunit'])
                            ->setMtoPrecioUnitario($detail['price'])
                            ->setMtoValorVenta($detail['subtotal'])
                            ->setTipAfeIgv($detail['idtipoafectacion'])
                            ->setMtoBaseIgv($detail['subtotal'])
                            ->setPorcentajeIgv($detail['tax'])
                            ->setIgv($detail['totaltax'])
                            ->setIcbper(($detail['qty']) * ($detail['icbper'])) // (cantidad)*(factor ICBPER)
                            ->setFactorIcbper($loc['icbper'])
                            ->setTotalImpuestos(($detail['totaltax']) + ($detail['qty']) * ($detail['icbper']));
                    $detalles[] = $items;
                }

                $leyenda = [];
                    $monto = new Legend();
                    $monto->setCode('1000')->setValue($totaletras);
                    $leyenda[] = $monto;
                    foreach(leyendas() as $value){
                        $leyendas = new Legend();
                        
                        $leyendas->setCode($value['id'])->setValue($value['valor']);                        
                        $leyenda[] = $leyendas; 
                    }
                    
                    $note->setDetails($detalles)->setLegends($leyenda);

// Envio a SUNAT.

                $rutacert = '/../resources/' . $loc['certificado'];
                $ruc = $loc['ruc'];
                $usuario = $loc['usuariosol'];
                $sol = $loc['clavesol'];
                if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                    $modo = SunatEndpoints::FE_PRODUCCION;
                } else {
                    $modo = SunatEndpoints::FE_BETA;
                    $ruc = '20123456789';

                    $usuario = 'MODDATOS';
                    $sol = 'moddatos';
                }
                
                $offline = $loc['online'];
                
                if ($offline == 0) {
                        $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);                        
                        $xml = $see->getXmlSigned($note);
                        $util->writeXml($note, $xml);
                        $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                        $filename = $note->getName();
                        $this->db->set(array('sunat' => 'Guardado', 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $invocieno);
                        $this->db->update('jsoft_stock_r');
                        $rpta = 'SE GENERÓ LA NOTA DE CRÉDITO SATISFACTORIAMENTE';
                        $transok = true;
                    }else {
                        $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                        $res = $see->send($note);
                        $util->writeXml($note, $see->getFactory()->getLastXml());
                        $xml = $see->getXmlSigned($note);

                if ($res->isSuccess()) {
                    /** @var $res \Greenter\Model\Response\BillResult */
                    $cdr = $res->getCdrResponse();
                    $util->writeCdr($note, $res->getCdrZip());
                    $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                    $code = (int) $cdr->getCode();
                    if ($code === 0 || $code === 'CDR') {
                        $rpta = $cdr->getDescription();
                        $filename = $note->getName();
                        $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $invocieno);
                        $this->db->update('jsoft_stock_r');
                        $linkxml = base_url('/files/' . $filename . '.xml');
                        //$linkzip = base_url('/files/' . $filename . '.zip');
                        $transok = true;
                        $this->db->set(array('refer' => $result_serie['serie'] . '-' . $invoicen, 'sunat' => 'Anulado'));
                        $this->db->where('id', $idcomprobante);
                        $this->db->update('jsoft_invoices');

//                        if (count($cdr->getNotes()) > 0) {
//                            echo 'OBSERVACIONES:' . PHP_EOL;
//                            // Corregir estas observaciones en siguientes emisiones.
//                            var_dump($cdr->getNotes());
//                        }
                    } else if ($code >= 2000 && $code <= 3999) {
                        $rpta = $cdr->getDescription();
                        $filename = $note->getName();
                        $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $invocieno);
                        $this->db->update('jsoft_stock_r');
                        $linkxml = base_url('/files/' . $filename . '.xml');
                        //$linkzip = base_url('/files/' . $filename . '.zip');
                        $transok = true;
                    } else {
                        $rpta = $cdr->getDescription();
                        $filename = $note->getName();
                        $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $invocieno);
                        $this->db->update('jsoft_stock_r');
                        $linkxml = base_url('/files/' . $filename . '.xml');
                        //$linkzip = base_url('/files/' . $filename . '.zip');
                        $transok = true;
                    }
                } else {
                    $rpta = $util->getErrorResponse($res->getError());
                    $transok = false;
                    echo json_encode(array('status' => 'Error', 'message' => $rpta));
                }
            }
            }

$linkpdf = base_url('/pos_invoices/thermal_pdf?id=' . $invocieno);

            if ($transok) {

                $this->db->set('pamnt', "0.00", FALSE);
                $this->db->set('total', "0.00", FALSE);
                $this->db->set('items', 0);
                $this->db->set('status', 'canceled');
                $this->db->where('id', $idcomprobante);
                $this->db->update('jsoft_invoices');
                //reverse
                $this->db->select('credit,debit,acid');
                $this->db->from('jsoft_transactions');
                $this->db->where('tid', $idcomprobante);
                $query1 = $this->db->get();
                $revresult = $query1->result_array();
                foreach ($revresult as $trans) {
                    $amt = $trans['credit'] - $trans['debit'];
                    $this->db->set('lastbal', "lastbal-$amt", FALSE);
                    $this->db->where('id', $trans['acid']);
                    $this->db->update('jsoft_accounts');
                }
                
                $this->db->delete('jsoft_transactions', array('tid' => $idcomprobante));
                $data = array('type' => 9, 'rid' => $idcomprobante);
                $this->db->delete('jsoft_metadata', $data);

                $this->load->library("Printer");
                $printer = $this->printer->check($this->aauth->get_user()->loc);
                $p_tid = 'thermal_p';
                if(is_array($printer)){
                    if ($printer['val2'] == 'server')
                    $p_tid = 'thermal_server';
                }
                
                echo json_encode(array('link' => $linkpdf,'status' => 'Success', 'message' => "<center>$rpta</center><br><center><a href='" . base_url("stockreturn/view?id=$invocieno") . "class='btn btn-primary btn-lg'><span class='fa fa-eye' aria-hidden='true'></span> " . $this->lang->line('View') . " </a> &nbsp;<a href='$linkxml' class='btn btn-flickr btn-lg'><span class='fa fa-file-code-o' aria-hidden='true'></span> XML</a></center>"));
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' => $this->lang->line('ERROR')));
            $transok = false;
        }

        if ($transok) {
            $this->db->trans_complete();
        } else {
            $this->db->trans_rollback();
        }
    }

    public function generar_xml_nota() {
        $this->load->helper('convertir');
        $tid = $this->input->get('id');
        $products = $this->stockreturn->purchase_products($tid);
        $notac = $this->stockreturn->purchase_details($tid);
        $loc = location($this->aauth->get_user()->loc);        
       

        $totaletras = num_to_letras($notac['total'], 'PEN');
        $codley = '2001';
        $leyenda = 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA';
        $this->db->trans_start();
        $transok = true;
        
        if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {
                $util = Util::getInstance();
// Cliente
                $client = new Client();
                $client->setTipoDoc($notac['iddoc'])
                        ->setNumDoc($notac['numdoc'])
                        ->setRznSocial($notac['name'])
                        ->setAddress((new Address())
                                ->setDireccion($notac['address']))
                        ->setEmail($notac['email'])
                        ->setTelephone($notac['phone']);
// Venta

                $note = new Note();
                $note
                        ->setUblVersion('2.1')
                        ->setTipoDoc($notac['numtipo_comprobante'])
                        ->setSerie($notac['serie'])
                        ->setCorrelativo($notac['tid'])
                        ->setFechaEmision(new DateTime($notac['invoicedate']))
                        ->setTipDocAfectado('03') // Tipo Doc: Nota de Credito
                        ->setNumDocfectado($notac['refer']) // Factura: Serie-Correlativo
                        ->setCodMotivo($notac['motivo']) // Catalogo. 09
                        ->setDesMotivo($notac['notes'])
                        ->setTipoMoneda('PEN')
//                    ->setGuias([/* Guias (Opcional) */
//                        (new Document())
//                        ->setTipoDoc('09')
//                        ->setNroDoc('0001-213')
//                    ])
                        ->setCompany((new Company())
                                ->setRuc($loc['ruc'])
                                ->setNombreComercial($loc['ncomercial'])
                                ->setRazonSocial($loc['cname'])
                                ->setAddress((new Address())
                                        ->setUbigueo($loc['ubigeo'])
                                        ->setDistrito($loc['city'])
                                        ->setProvincia($loc['region'])
                                        ->setDepartamento($loc['country'])
                                        ->setUrbanizacion('NONE')
                                        ->setCodLocal($loc['codlocal'])
                                        ->setDireccion($loc['address']))
                                ->setEmail($loc['email'])
                                ->setTelephone($loc['phone']))
                        ->setClient($client)
                        ->setMtoOperGravadas(0.00)
                        ->setMtoOperExoneradas($notac['subtotal'])
                        ->setMtoIGV($notac['tax'])
                        ->setIcbper($notac['icbper'])
                        ->setTotalImpuestos($notac['tax'] + $notac['icbper'])                       
                        ->setMtoImpVenta($notac['total']);

                $detalles = [];
                foreach ($products as $detail) {
                    $items = new SaleDetail();
                    $items->setCodProducto($detail['code'])
                            ->setUnidad($detail['unit'])
                            ->setCantidad($detail['qty'])
                            ->setDescripcion($detail['product'])
                            ->setMtoValorUnitario($detail['valorunit'])
                            ->setMtoPrecioUnitario($detail['price'])
                            ->setMtoValorVenta($detail['subtotal'])
                            ->setTipAfeIgv($detail['idtipoafectacion'])
                            ->setMtoBaseIgv($detail['subtotal'])
                            ->setPorcentajeIgv($detail['tax'])
                            ->setIgv($detail['totaltax'])
                            ->setIcbper(($detail['qty']) * ($detail['icbper'])) // (cantidad)*(factor ICBPER)
                            ->setFactorIcbper($loc['icbper'])
                            ->setTotalImpuestos(($detail['totaltax']) + ($detail['qty']) * ($detail['icbper']));
                    $detalles[] = $items;
                }

                $leyenda = [];
                    $monto = new Legend();
                    $monto->setCode('1000')->setValue($totaletras);
                    $leyenda[] = $monto;
                    foreach(leyendas() as $value){
                        $leyendas = new Legend();
                        
                        $leyendas->setCode($value['id'])->setValue($value['valor']);                        
                        $leyenda[] = $leyendas; 
                    }
                    
                    $note->setDetails($detalles)->setLegends($leyenda);

// Envio a SUNAT.

                $rutacert = '/../resources/' . $loc['certificado'];
                $ruc = $loc['ruc'];
                $usuario = $loc['usuariosol'];
                $sol = $loc['clavesol'];
                if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                    $modo = SunatEndpoints::FE_PRODUCCION;
                } else {
                    $modo = SunatEndpoints::FE_BETA;
                    $ruc = '20123456789';

                    $usuario = 'MODDATOS';
                    $sol = 'moddatos';
                }            
                
               
                    $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                    $res = $see->send($note);
                    $util->writeXml($note, $see->getFactory()->getLastXml());
                    $xml = $see->getXmlSigned($note);

                    if ($res->isSuccess()) {
                        /** @var $res \Greenter\Model\Response\BillResult */
                        $cdr = $res->getCdrResponse();
                        $util->writeCdr($note, $res->getCdrZip());
                        $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                        $code = (int) $cdr->getCode();
                        if ($code === 0 || $code === 'CDR') {
                            $rpta = $cdr->getDescription();
                            $filename = $note->getName();
                            $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                            $this->db->where('id', $tid);
                            $this->db->update('jsoft_stock_r');
                            
                            $transok = true;
                           
                        } else if ($code >= 2000 && $code <= 3999) {
                            $rpta = $cdr->getDescription();
                            $filename = $note->getName();
                            $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                            $this->db->where('id', $tid);
                            $this->db->update('jsoft_stock_r');                            
                            $transok = true;
                        } else {
                            $rpta = $cdr->getDescription();
                            $filename = $note->getName();
                            $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                            $this->db->where('id', $tid);
                            $this->db->update('jsoft_stock_r');                            
                            $transok = true;
                        }

                    } else {
                        $rpta = $util->getErrorResponse($res->getError());
                        $transok = false;
                        echo json_encode(array('status' => 'Error', 'message' => $rpta));
                    }
                    
                    echo json_encode(array('status' => 'Success', 'message' => $rpta));
                
            }

        if ($transok) {
            $this->db->trans_complete();
        } else {
            $this->db->trans_rollback();
        }
    }

    public function ajax_list() {
        $no = $this->input->post('start');
        $type = $this->input->get('t');
        $list = $this->stockreturn->get_datatables($type);
        $data = array();
        foreach ($list as $invoices) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = '<a href="' . base_url("stockreturn/view?id=$invoices->id") . '">&nbsp; ' . $invoices->tid . '</a>';
            $row[] = $invoices->name;
            $row[] = dateformat($invoices->invoicedate);
            $row[] = amountExchange($invoices->total, 0, $this->aauth->get_user()->loc);
            $row[] = '<span class="badge st-' . $invoices->sunat . '">' . ucwords($invoices->sunat) . '</span>';
            $row[] = $invoices->refer;
            $row[] = '<a href="' . base_url("stockreturn/view?id=$invoices->id") . '" class="btn btn-success btn-sm"><i class="fa fa-eye"></i> ' . $this->lang->line('View') . '</a> &nbsp; <a href="' . base_url("stockreturn/printinvoice?id=$invoices->id") . '&d=1" class="btn btn-info btn-sm"  title="Download"><span class="fa fa-download"></span></a>&nbsp;<a href="#" data-object-id="' . $invoices->id . '" class="btn btn-danger btn-sm delete-object"><span class="fa fa-trash"></span></a>';
            $data[] = $row;
        }
        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->stockreturn->count_all(),
            "recordsFiltered" => $this->stockreturn->count_filtered(),
            "data" => $data,
        );
        //salida en formato json
        echo json_encode($output);
    }
    
    //lista de comunicaciones de baja
    public function ajax_list_com_b() {
        $no = $this->input->post('start');
        $type = $this->input->get('t');
        $list = $this->stockreturn->get_datatables_com_b($type);
        $data = array();
        foreach ($list as $invoices) {
            $no++;
            $row = array();
            $row[] = $no;
            
            $row[] = dateformat($invoices->fechaemision);
            $row[] = $invoices->name;
            $row[] = $invoices->referencia;
            $row[] = amountExchange($invoices->total, 0, $this->aauth->get_user()->loc);
            $row[] = '<span class="badge st-' . $invoices->status . '">' . ucwords($invoices->status) . '</span>';
            $row[] = $invoices->ticket;
            $row[] = $invoices->motivo;
            $row[] = '<a href="' . base_url("stockreturn/view?id=$invoices->idcom") . '" class="btn btn-info btn-sm"><i class="fa fa-ticket"></i>  Consultar Ticket </a> &nbsp;<a href="#" data-object-id="' . $invoices->idcom . '" class="btn btn-danger btn-sm delete-object"><span class="fa fa-trash"></span></a>';
            $data[] = $row;
        }
        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->stockreturn->count_all_com_b(),
            "recordsFiltered" => $this->stockreturn->count_filtered_com_b(),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }
    
    public function reenviar_xml() {
        $this->load->model('accounts_model');
        
        $tid = intval($this->input->get('id'));
        $xml = $this->input->get('xml');
        $idcomp = intval($this->input->get('idcomp'));
        $serie = $this->input->get('serie');
        
        if (!empty($xml)) {
            $loc = location($this->aauth->get_user()->loc);

            $util = Util::getInstance();

            $rutacert = '/../resources/' . $loc['certificado'];
            $ruc = $loc['ruc'];
            $usuario = $loc['usuariosol'];
            $sol = $loc['clavesol'];
            if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                $modo = SunatEndpoints::FE_PRODUCCION;
            } else {
                $modo = SunatEndpoints::FE_BETA;
                $ruc = '20123456789';

                $usuario = 'MODDATOS';
                $sol = 'moddatos';
            }

            $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);

            /* Si solo desea enviar un XML ya generado utilice esta función */
            //$res = $see->sendXmlFile(get_class($invoice), $invoice->getName(), file_get_contents($ruta_XML));

            $res = $see->sendXmlFile(file_get_contents('./files/' . $xml.'.xml'));

            if ($res->isSuccess()) {
                $cdr = $res->getCdrResponse();
                $code = (int) $cdr->getCode();
                
                if ($code === 0 || $code === 'CDR') {
                   $rpta= $cdr->getDescription();
                    
                    $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    $this->db->set(array('refer' => $serie . '-' . $tid, 'sunat' => 'Anulado'));
                    $this->db->where('id', $idcomp);
                    $this->db->update('jsoft_invoices');
                    $estado = 'Success';
                    
                    
                } else if ($code >= 2000 || $code <= 3999) {
                    $rpta = $cdr->getDescription();
                    $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    $estado = 'Error';
                    
                } else {
                  $rpta= $cdr->getDescription();
                    $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    $estado = 'Error';
                }
                
            } else {
                $rpta = $util->getErrorResponse($res->getError());
                $estado = 'Error';

//                echo json_encode(array('status' => 'Error', 'message' => $rpta));
            }
            echo json_encode(array('status' => $estado, 'message' => $rpta));
        }
    }

    public function view() {
        $this->load->model('accounts_model');
        $data['acclist'] = $this->accounts_model->accountslist();
        $tid = intval($this->input->get('id'));
        $xml = $this->input->get('xml');
        $idcomp = intval($this->input->get('idcomp'));
        $serie = $this->input->get('serie');
        
        if (!empty($xml)) {
            $loc = location($this->aauth->get_user()->loc);

            $util = Util::getInstance();

            $rutacert = '/../resources/' . $loc['certificado'];
            $ruc = $loc['ruc'];
            $usuario = $loc['usuariosol'];
            $sol = $loc['clavesol'];
            if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                $modo = SunatEndpoints::FE_PRODUCCION;
            } else {
                $modo = SunatEndpoints::FE_BETA;
                $ruc = '20123456789';

                $usuario = 'MODDATOS';
                $sol = 'moddatos';
            }

            $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);

            /* Si solo desea enviar un XML ya generado utilice esta función */
            //$res = $see->sendXmlFile(get_class($invoice), $invoice->getName(), file_get_contents($ruta_XML));

            $res = $see->sendXmlFile(file_get_contents('./files/' . $xml.'.xml'));

            if ($res->isSuccess()) {
                $cdr = $res->getCdrResponse();
                $code = (int) $cdr->getCode();
                
                if ($code === 0 || $code === 'CDR') {
                   $rpta= $cdr->getDescription();
                    
                    $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    $this->db->set(array('sunat' => 'Anulado'));
                    $this->db->where('id', $idcomp);
                    $this->db->update('jsoft_invoices');
                    $estado = 'Success';
                    
                    
                } else if ($code >= 2000 || $code <= 3999) {
                    $rpta = $cdr->getDescription();
                    $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    $estado = 'Error';
                    
                } else {
                  $rpta= $cdr->getDescription();
                    $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    $estado = 'Error';
                }
                
            } else {
                $rpta = $util->getErrorResponse($res->getError());
                $estado = 'Error';

//                echo json_encode(array('status' => 'Error', 'message' => $rpta));
            }
            echo json_encode(array('status' => $estado, 'message' => $rpta));
        }else{
        $data['id'] = $tid;
        $data['invoice'] = $this->stockreturn->purchase_details($tid);
        $data['products'] = $this->stockreturn->purchase_products($tid);
        $data['activity'] = $this->stockreturn->purchase_transactions($tid);
        $data['attach'] = $this->stockreturn->attach($tid);
        $data['employee'] = $this->stockreturn->employee($data['invoice']['eid']);
        $head['usernm'] = $this->aauth->get_user()->username;
        $head['title'] = "Orden de devolución de stock " . $data['invoice']['iid'];
        if (($data['invoice']['i_class'] != 2 && $this->aauth->premission(2)) or ( $data['invoice']['i_class'] == 2 && $this->aauth->premission(1))) {
            $this->load->view('fixed/header', $head);
            if ($data['invoice']['tid'])
                $this->load->view('stockreturn/view', $data);
            $this->load->view('fixed/footer');
        }
       }
    }

    public function printinvoice() {
        $tid = $this->input->get('id');
        $ty = $this->input->get('ty');
        $data['id'] = $tid;
        $data['title'] = "Stock Return $tid";
        $data['invoice'] = $this->stockreturn->purchase_details($tid);
        $data['products'] = $this->stockreturn->purchase_products($tid);
        $data['employee'] = $this->stockreturn->employee($data['invoice']['eid']);
        if (($data['invoice']['i_class'] != 2 && $this->aauth->premission(2)) or ( $data['invoice']['i_class'] == 2 && $this->aauth->premission(1))) {
            if ($ty < 2) {
                $data['general'] = array('title' => $this->lang->line('Stock Return'), 'person' => $this->lang->line('Supplier'), 'prefix' => prefix(4), 't_type' => 0);
            } else {
                $data['general'] = array('title' => $this->lang->line('Credit Note'), 'person' => $this->lang->line('Customer'), 'prefix' => prefix(4), 't_type' => 0);
            }
            ini_set('memory_limit', '64M');
            if ($data['invoice']['taxstatus'] == 'cgst' || $data['invoice']['taxstatus'] == 'igst') {
                $html = $this->load->view('print_files/invoice-a4-gst_v' . INVV, $data, true);
            } else {
                $html = $this->load->view('print_files/invoice-a4_v' . INVV, $data, true);
            }
            //PDF Rendering
            $this->load->library('pdf');
            if (INVV == 1) {
                $header = $this->load->view('print_files/invoice-header_v' . INVV, $data, true);
                $pdf = $this->pdf->load_split(array('margin_top' => 40));
                $pdf->SetHTMLHeader($header);
            }
            if (INVV == 2) {
                $pdf = $this->pdf->load_split(array('margin_top' => 5));
            }
            $pdf->SetHTMLFooter('<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $data['invoice']['tid'] . '</div>');
            $pdf->WriteHTML($html);
            $file_name = preg_replace('/[^A-Za-z0-9]+/', '-', 'Credit_note__' . $data['invoice']['name'] . '_' . $data['invoice']['tid']);
            if ($this->input->get('d')) {
                $pdf->Output($file_name . '.pdf', 'D');
            } else {
                $pdf->Output($file_name . '.pdf', 'I');
            }
        }
    }

    public function delete_i() {
        $id = $this->input->post('deleteid');
        if ($this->stockreturn->purchase_delete($id, $this->limited)) {
            echo json_encode(array('status' => 'Success', 'message' =>
                $this->lang->line('DELETED')));
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
        }
    }

    public function editaction() {
        $customer_id = $this->input->post('customer_id');
        $person_type = $this->input->post('person_type');
        if ($person_type) {
            if (!$this->aauth->premission(2)) {
                exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
            }
        }
        if ($person_type == 2) {
            if (!$this->aauth->premission(1)) {
                exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
            }
        }
        $invocieno = $this->input->post('iid');
        $invoicedate = $this->input->post('invoicedate');
        $invocieduedate = $this->input->post('invocieduedate');
        $notes = $this->input->post('notes', true);
        $tax = $this->input->post('tax_handle');
        $ship_taxtype = $this->input->post('ship_taxtype');
        $total_tax = 0;
        $total_discount = 0;
        $discountFormat = $this->input->post('discountFormat');
        $pterms = $this->input->post('pterms');
        $i = 0;
        if ($discountFormat == '0') {
            $discstatus = 0;
        } else {
            $discstatus = 1;
        }
        if ($customer_id == 0) {
            echo json_encode(array('status' => 'Error', 'message' =>
                "Por favor, agregue un nuevo proveedor o busque uno ya existente."));
            exit;
        }
        $currency = $this->input->post('mcurrency');
        $subtotal = rev_amountExchange_s($this->input->post('subtotal'), $currency, $this->aauth->get_user()->loc);
        $shipping = rev_amountExchange_s($this->input->post('shipping'), $currency, $this->aauth->get_user()->loc);
        $shipping_tax = rev_amountExchange_s($this->input->post('ship_tax'), $currency, $this->aauth->get_user()->loc);
        if ($ship_taxtype == 'incl')
            $shipping = $shipping - $shipping_tax;
        $refer = $this->input->post('refer', true);
        $total = rev_amountExchange_s($this->input->post('total'), $currency, $this->aauth->get_user()->loc);
        $this->db->trans_start();
        $flag = false;
        $transok = true;
        //Product Data
        $pid = $this->input->post('pid');
        $productlist = array();
        $prodindex = 0;
        $this->db->delete('jsoft_stock_r_items', array('tid' => $invocieno));
        $product_id = $this->input->post('pid');
        $product_name1 = $this->input->post('product_name', true);
        $product_qty = $this->input->post('product_qty');
        $old_product_qty = $this->input->post('old_product_qty');
        if ($old_product_qty == '')
            $old_product_qty = 0;
        $product_price = $this->input->post('product_price');
        $product_tax = $this->input->post('product_tax');
        $product_discount = $this->input->post('product_discount');
        $product_subtotal = $this->input->post('product_subtotal');
        $ptotal_tax = $this->input->post('taxa');
        $ptotal_disc = $this->input->post('disca');
        $product_des = $this->input->post('product_description', true);
        $product_unit = $this->input->post('unit');
        $product_hsn = $this->input->post('hsn');
        foreach ($pid as $key => $value) {
            $total_discount += numberClean(@$ptotal_disc[$key]);
            $total_tax += numberClean($ptotal_tax[$key]);
            $data = array(
                'tid' => $invocieno,
                'pid' => $product_id[$key],
                'product' => $product_name1[$key],
                'code' => $product_hsn[$key],
                'qty' => numberClean($product_qty[$key]),
                'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                'tax' => numberClean($product_tax[$key]),
                'discount' => numberClean($product_discount[$key]),
                'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                'product_des' => $product_des[$key],
                'unit' => $product_unit[$key]
            );
            $productlist[$prodindex] = $data;
            $i++;
            $prodindex++;
            if ($this->input->post('update_stock') == 'yes') {
                $amt = numberClean(@$product_qty[$key]) - numberClean(@$old_product_qty[$key]);
                $this->db->set('qty', "qty-$amt", FALSE);
                $this->db->where('pid', $product_id[$key]);
                $this->db->update('jsoft_products');
            }
            $flag = true;
        }
        $bill_date = datefordatabase($invoicedate);
        $bill_due_date = datefordatabase($invocieduedate);
        $data = array('invoicedate' => $bill_date, 'invoiceduedate' => $bill_due_date, 'subtotal' => $subtotal, 'shipping' => $shipping, 'ship_tax' => $shipping_tax, 'ship_tax_type' => $ship_taxtype, 'discount' => $total_discount, 'tax' => $total_tax, 'total' => $total, 'notes' => $notes, 'csd' => $customer_id, 'items' => $i, 'taxstatus' => $tax, 'discstatus' => $discstatus, 'format_discount' => $discountFormat, 'refer' => $refer, 'term' => $pterms, 'i_class' => $person_type);
        $this->db->set($data);
        $this->db->where('id', $invocieno);
        if ($flag) {
            if ($this->db->update('jsoft_stock_r', $data)) {
                $this->db->insert_batch('jsoft_stock_r_items', $productlist);
                echo json_encode(array('status' => 'Success', 'message' =>
                    "Updated! <a href='view?id=$invocieno' class='btn btn-info btn-lg'><span class='fa fa-eye' aria-hidden='true'></span> View </a> "));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                    "There is a missing field!"));
                $transok = false;
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
                "Please add atleast one product in order!"));
            $transok = false;
        }

        if ($this->input->post('update_stock') == 'yes') {
            if ($this->input->post('restock')) {
                foreach ($this->input->post('restock') as $key => $value) {
                    $myArray = explode('-', $value);
                    $prid = $myArray[0];
                    $dqty = numberClean($myArray[1]);
                    if ($prid > 0) {
                        $this->db->set('qty', "qty-$dqty", FALSE);
                        $this->db->where('pid', $prid);
                        $this->db->update('jsoft_products');
                    }
                }
            }
        }
        if ($transok) {
            $this->db->trans_complete();
        } else {
            $this->db->trans_rollback();
        }
    }

    public function update_status() {
        $tid = $this->input->post('tid');
        $status = $this->input->post('status');
        $this->db->select('i_class');
        $this->db->from('jsoft_stock_r');
        $this->db->where('id', $tid);
        $query = $this->db->get();
        $stock = $query->row_array();
        if (($stock['i_class'] != 2 && $this->aauth->premission(2)) or ( $stock['i_class'] == 2 && $this->aauth->premission(1))) {
            $this->db->set('status', $status);
            $this->db->where('id', $tid);
            $this->db->update('jsoft_stock_r');
            echo json_encode(array('status' => 'Success', 'message' =>
                'Status updated successfully!', 'pstatus' => $status));
        }
    }

    public function file_handling() {
        if ($this->input->get('op')) {
            $name = $this->input->get('name');
            $invoice = $this->input->get('invoice');
            if ($this->stockreturn->meta_delete($invoice, 5, $name)) {
                echo json_encode(array('status' => 'Success'));
            }
        } else {
            $id = $this->input->get('id');
            $this->load->library("Uploadhandler_generic", array(
                'accept_file_types' => '/\.(gif|jpe?g|png|docx|docs|txt|pdf|xls)$/i', 'upload_dir' => FCPATH . 'userfiles/attach/', 'upload_url' => base_url() . 'userfiles/attach/'
            ));
            $files = (string) $this->uploadhandler_generic->filenaam();
            if ($files != '') {
                $this->stockreturn->meta_insert($id, 5, $files);
            }
        }
    }

    public function cancelorder() {
        $tid = intval($this->input->post('tid'));
        $this->db->select('i_class');
        $this->db->from('jsoft_stock_r');
        $this->db->where('id', $tid);
        $query = $this->db->get();
        $stock = $query->row_array();
        if (($stock['i_class'] != 2 && $this->aauth->premission(2)) or ( $stock['i_class'] == 2 && $this->aauth->premission(1))) {
            $this->db->set('pamnt', "0.00", FALSE);
            $this->db->set('status', 'canceled');
            $this->db->where('id', $tid);
            $this->db->update('jsoft_stock_r');
            //reverse
            $this->db->select('credit,acid');
            $this->db->from('jsoft_transactions');
            $this->db->where('tid', $tid);
            $this->db->where('ext', 6);
            $query = $this->db->get();
            $revresult = $query->result_array();
            foreach ($revresult as $trans) {
                $amt = $trans['credit'];
                $this->db->set('lastbal', "lastbal-$amt", FALSE);
                $this->db->where('id', $trans['acid']);
                $this->db->update('jsoft_accounts');
            }
            $this->db->select('pid,qty');
            $this->db->from('jsoft_stock_r_items');
            $this->db->where('tid', $tid);
            $query = $this->db->get();
            $prevresult = $query->result_array();
            foreach ($prevresult as $prd) {
                $amt = $prd['qty'];
                $this->db->set('qty', "qty+$amt", FALSE);
                $this->db->where('pid', $prd['pid']);
                $this->db->update('jsoft_products');
            }
            $this->db->delete('jsoft_transactions', array('tid' => $tid, 'ext' => 6));
            echo json_encode(array('status' => 'Success', 'message' =>
                $this->lang->line('Return canceled')));
        }
    }

    public function pay() {
        $this->load->library("Custom");
        $tid = intval($this->input->post('tid'));
        $this->db->select('i_class');
        $this->db->from('jsoft_stock_r');
        $this->db->where('id', $tid);
        $query = $this->db->get();
        $stock = $query->row_array();
        if (($stock['i_class'] != 2 && $this->aauth->premission(2)) or ( $stock['i_class'] == 2 && $this->aauth->premission(1))) {

            $amount = rev_amountExchange_s($this->input->post('amount', true), 0, $this->aauth->get_user()->loc);
            $paydate = $this->input->post('paydate');
            $note = $this->input->post('shortnote', true);
            $pmethod = $this->input->post('pmethod');
            $acid = $this->input->post('account');
            $cid = $this->input->post('cid');
            $cname = $this->input->post('cname', true);
            $paydate = datefordatabase($paydate);


            if ($stock['i_class'] == 2 or $stock['i_class'] == 1) {
                $this->db->select('holder');
                $this->db->from('jsoft_accounts');
                $this->db->where('id', $acid);
                $query = $this->db->get();
                $account = $query->row_array();

                $data = array(
                    'acid' => $acid,
                    'account' => $account['holder'],
                    'type' => 'Expense',
                    'cat' => 'Credit Note',
                    'debit' => $amount,
                    'payer' => $cname,
                    'payerid' => $cid,
                    'method' => $pmethod,
                    'date' => $paydate,
                    'eid' => $this->aauth->get_user()->id,
                    'tid' => $tid,
                    'note' => $note,
                    'ext' => 6
                );
                $this->db->insert('jsoft_transactions', $data);
                $this->db->insert_id();
                $this->db->select('total,csd,pamnt');
                $this->db->from('jsoft_stock_r');
                $this->db->where('id', $tid);
                $query = $this->db->get();
                $invresult = $query->row();
                $totalrm = $invresult->total - $invresult->pamnt;
                if ($totalrm > $amount) {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);
                    $this->db->set('status', 'partial');
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    //account update
                    $this->db->set('lastbal', "lastbal-$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('jsoft_accounts');
                    $paid_amount = $invresult->pamnt + $amount;
                    $status = 'Partial';
                    $totalrm = $totalrm - $amount;
                } else {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);
                    $this->db->set('status', 'accepted');
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    //acount update
                    $this->db->set('lastbal', "lastbal-$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('jsoft_accounts');
                    $totalrm = 0;
                    $status = 'Accepted';
                    $paid_amount = $amount;
                }
                $dual = $this->custom->api_config(65);
                if ($dual['key1']) {

                    $this->db->select('holder');
                    $this->db->from('jsoft_accounts');
                    $this->db->where('id', $dual['url']);
                    $query = $this->db->get();
                    $account = $query->row_array();

                    $data['debit'] = 0;
                    $data['credit'] = $amount;
                    $data['type'] = 'Income';
                    $data['acid'] = $dual['url'];
                    $data['account'] = $account['holder'];
                    $data['note'] = 'Credit ' . $data['note'];

                    $this->db->insert('jsoft_transactions', $data);

                    //account update
                    $this->db->set('lastbal', "lastbal+$amount", FALSE);
                    $this->db->where('id', $dual['url']);
                    $this->db->update('jsoft_accounts');
                }
            } else {


                $this->db->select('holder');
                $this->db->from('jsoft_accounts');
                $this->db->where('id', $acid);
                $query = $this->db->get();
                $account = $query->row_array();

                $data = array(
                    'acid' => $acid,
                    'account' => $account['holder'],
                    'type' => 'Income',
                    'cat' => 'Purchase',
                    'credit' => $amount,
                    'payer' => $cname,
                    'payerid' => $cid,
                    'method' => $pmethod,
                    'date' => $paydate,
                    'eid' => $this->aauth->get_user()->id,
                    'tid' => $tid,
                    'note' => $note,
                    'ext' => 6
                );
                $this->db->insert('jsoft_transactions', $data);
                $this->db->insert_id();
                $this->db->select('total,csd,pamnt');
                $this->db->from('jsoft_stock_r');
                $this->db->where('id', $tid);
                $query = $this->db->get();
                $invresult = $query->row();
                $totalrm = $invresult->total - $invresult->pamnt;
                if ($totalrm > $amount) {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);
                    $this->db->set('status', 'partial');
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    //account update
                    $this->db->set('lastbal', "lastbal-$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('jsoft_accounts');
                    $paid_amount = $invresult->pamnt + $amount;
                    $status = 'Partial';
                    $totalrm = $totalrm - $amount;
                } else {
                    $this->db->set('pmethod', $pmethod);
                    $this->db->set('pamnt', "pamnt+$amount", FALSE);
                    $this->db->set('status', 'accepted');
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_stock_r');
                    //acount update
                    $this->db->set('lastbal', "lastbal-$amount", FALSE);
                    $this->db->where('id', $acid);
                    $this->db->update('jsoft_accounts');
                    $totalrm = 0;
                    $status = 'Accepted';
                    $paid_amount = $amount;
                }
            }


            $activitym = "<tr><td>" . substr($paydate, 0, 10) . "</td><td>$pmethod</td><td>$amount</td><td>$note</td></tr>";
            echo json_encode(array('status' => 'Success', 'message' =>
                $this->lang->line('Transaction has been added'), 'pstatus' => $this->lang->line($status), 'activity' => $activitym, 'amt' => $totalrm, 'ttlpaid' => $paid_amount));
        }
    }
    
    public function comunicacionbaja() {
        if (!$this->aauth->premission(1)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $head['title'] = "Comunicaciones de Baja";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('stockreturn/comunicacionbaja');
        $this->load->view('fixed/footer');
    }

}
