<?php


defined('BASEPATH') or exit('No direct script access allowed');

use Greenter\Model\Sale\Invoice;
use Greenter\Model\Sale\SaleDetail;
use Greenter\Model\Sale\Legend;
use Greenter\Ws\Services\SunatEndpoints;
use Greenter\Model\Client\Client;
use Greenter\Model\Company\Address;
use Greenter\Model\Company\Company;
use Greenter\Model\Sale\FormaPagos\FormaPagoContado;

require 'vendor/autoload.php';
class Pos_invoices_model extends CI_Model
{
    var $table = 'jsoft_invoices';
    var $column_order_conting = array(null, 'jsoft_contingencia.tid', 'jsoft_contingencia.name', 'jsoft_contingencia.invoicedate', 'jsoft_contingencia.total', 'jsoft_contingencia.status', null);
    var $column_order = array(null, 'jsoft_invoices.tid', 'jsoft_customers.name', 'jsoft_invoices.invoicedate', 'jsoft_invoices.total', 'jsoft_invoices.status', null);
    var $column_search_cont = array('jsoft_contingencia.tid', 'jsoft_customers.name', 'jsoft_contingencia.invoicedate', 'jsoft_contingencia.total', 'jsoft_contingencia.status', 'jsoft_invoices.sunat');
    var $column_search = array('jsoft_invoices.tid', 'jsoft_customers.name', 'jsoft_invoices.invoicedate', 'jsoft_invoices.total', 'jsoft_invoices.status', 'jsoft_invoices.sunat');
    var $order = array('jsoft_invoices.tid' => 'desc');
    var $order_conting = array('jsoft_contingencia.tid' => 'desc');

    public function __construct()
    {
        parent::__construct();
    }

    //GENERA ID DE COMPROBANTE SI ES EMISOR ELECTRONICO
    public function lastinvoice($param, $param2)
    {

        $this->db->select('tid');
        $this->db->from($this->table);
        $this->db->where('i_class', 1);
        $this->db->where('tipocomprobante', $param);
        $this->db->where('idserie', $param2);
        $this->db->where('loc', $this->aauth->get_user()->loc);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);

        $query = $this->db->get()->result();
        if (empty($query)) {
            $n = "00000001";
            return $n;
        } else {
            foreach ($query as $obj) {
                $correlativo = $obj->tid;
            }
            $n = intval($correlativo) + 1;
            if (strlen($n) >= 8) {
                return $n;
            }
            $numerodeceros = 8 - strlen($n);
            for ($i = 0; $i < $numerodeceros; $i++) {
                $n = "0" . $n;
            }
            return $n;
        }
    }


    //GENERA CORRELATIVO DE GUIA DE REMISION
    public function correlativoguia($param, $param2)
    {

        $this->db->select('correlativo');
        $this->db->from('jsoft_guia_remision');
        //$this->db->where('i_class', 1);
        //$this->db->where('tipocomprobante', $param);
        $this->db->where('serie', $param2);
        //$this->db->where('loc', $this->aauth->get_user()->loc);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);

        $query = $this->db->get()->result();
        if (empty($query)) {
            $n = "00000001";
            return $n;
        } else {
            foreach ($query as $obj) {
                $correlativo = $obj->correlativo;
            }
            $n = intval($correlativo) + 1;
            if (strlen($n) >= 8) {
                return $n;
            }
            $numerodeceros = 8 - strlen($n);
            for ($i = 0; $i < $numerodeceros; $i++) {
                $n = "0" . $n;
            }
            return $n;
        }
    }

    //GENERA ID DE COMPROBANTE SI NO ES EMISOR ELECTRONICO
    public function idnoE()
    {
        $this->db->select('tid');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $this->db->where('i_class', 1);
        $this->db->where('loc', $this->aauth->get_user()->loc);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->tid;
        } else {
            return 10000000;
        }
    }

    public function correlativoresumen()
    {

        $this->db->select('id');
        $this->db->from('jsoft_resumen_diario');
        $this->db->where('loc', $this->aauth->get_user()->loc);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);

        $query = $this->db->get()->result();
        if (empty($query)) {
            $n = "001";
            return $n;
        } else {
            foreach ($query as $obj) {
                $correlativo = $obj->tid;
            }
            $n = intval($correlativo) + 1;
            if (strlen($n) >= 3) {
                return $n;
            }
            $numerodeceros = 3 - strlen($n);
            for ($i = 0; $i < $numerodeceros; $i++) {
                $n = "0" . $n;
            }
            return $n;
        }
    }

    public function tipoprecio()
    {
        $this->db->select('id,descripcion');
        $this->db->from('tipoprecio');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function tipoafectacion()
    {
        $this->db->select('id,descripcion');
        $this->db->from('tipoafectacion');
        $query = $this->db->get();
        return $query->result_array();
    }


    public function invoice_details($id, $eid = '', $loc = null)
    {
        $this->db->select('jsoft_invoices.*,s.serie, SUM(jsoft_invoices.shipping + jsoft_invoices.ship_tax) AS shipping,jsoft_customers.*,jsoft_invoices.loc as loc,jsoft_invoices.id AS iid,jsoft_customers.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms, jsoft_customers.iddoc AS doccliente, tc.numtipo_comprobante, jtr.title, tc.nombre_docu, tc.idtipocomprobante');
        $this->db->from($this->table);
        $this->db->join('serie s', 'jsoft_invoices.idserie = s.id');
        $this->db->join('tipocomprobante tc', 'jsoft_invoices.tipocomprobante = tc.idtipocomprobante');
        $this->db->join('jsoft_terms jtr', 'jsoft_invoices.term = jtr.id');
        $this->db->where('jsoft_invoices.id', $id);
        if ($eid) {
            $this->db->where('jsoft_invoices.eid', $eid);
        }
        if (@$this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA and !$loc) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        if ($loc) {

            $this->db->where('jsoft_invoices.loc', $loc);
        }
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd = jsoft_customers.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_invoices.term', 'left');
        $query = $this->db->get();

        return $query->row_array();
    }

    public function facturas_resumen($date, $eid = '', $loc = null)
    {
        $this->db->select('jsoft_invoices.*,s.serie, SUM(jsoft_invoices.shipping + jsoft_invoices.ship_tax) AS shipping,jsoft_customers.*,jsoft_invoices.loc as loc,jsoft_invoices.id AS iid,jsoft_customers.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms, jsoft_customers.iddoc AS doccliente, tc.numtipo_comprobante');
        $this->db->from($this->table);
        $this->db->join('serie s', 'jsoft_invoices.idserie = s.id');
        $this->db->join('tipocomprobante tc', 'jsoft_invoices.tipocomprobante = tc.idtipocomprobante');
        $this->db->where('jsoft_invoices.tipocomprobante', 'B');
        $this->db->where('jsoft_invoices.idserie', '3');
        $this->db->where('DATE(jsoft_invoices.invoicedate)', $date);
        $this->db->or_where('jsoft_invoices.respuesta', null);
        $this->db->where('jsoft_invoices.sunat', 'Guardado');
        $this->db->or_where('jsoft_invoices.sunat', 'Anulado');
        if ($eid) {
            $this->db->where('jsoft_invoices.eid', $eid);
        }
        if (@$this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA and !$loc) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        if ($loc) {

            $this->db->where('jsoft_invoices.loc', $loc);
        }
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd = jsoft_customers.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_invoices.term', 'left');
        $query = $this->db->get();

        return $query->result_array();
    }

    public function invoice_products($id)
    {

        $this->db->select('*');
        $this->db->from('jsoft_invoice_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function currencies()
    {

        $this->db->select('*');
        $this->db->from('jsoft_currencies');

        $query = $this->db->get();
        return $query->result_array();
    }

    public function currency_d($id)
    {
        $this->db->select('*');
        $this->db->from('jsoft_currencies');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function warehouses()
    {
        $this->db->select('*');
        $this->db->from('jsoft_warehouse');
        if ($this->aauth->get_user()->loc) {
            $this->db->where('loc', $this->aauth->get_user()->loc);
            if (BDATA)  $this->db->or_where('loc', 0);
        } elseif (!BDATA) {
            $this->db->where('loc', 0);
        }

        $query = $this->db->get();

        return $query->result_array();
    }

    public function invoice_transactions($id)
    {

        $this->db->select('*');
        $this->db->from('jsoft_transactions');
        $this->db->where('tid', $id);
        $this->db->where('ext', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function invoice_delete($id, $eid = '')
    {

        $this->db->trans_start();

        $this->db->select('status');
        $this->db->from('jsoft_invoices');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->row_array();

        if ($this->aauth->get_user()->loc) {
            if ($eid) {
                $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'eid' => $eid, 'loc' => $this->aauth->get_user()->loc));
            } else {
                $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'loc' => $this->aauth->get_user()->loc));
            }
        } else {
            if (BDATA) {
                if ($eid) {
                    $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'eid' => $eid));
                } else {
                    $res = $this->db->delete('jsoft_invoices', array('id' => $id));
                }
            } else {
                if ($eid) {
                    $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'eid' => $eid, 'loc' => 0));
                } else {
                    $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'loc' => 0));
                }
            }
        }
        $affect = $this->db->affected_rows();
        if ($res) {
            if ($result['status'] != 'canceled') {
                $this->db->select('pid,qty');
                $this->db->from('jsoft_invoice_items');
                $this->db->where('tid', $id);
                $query = $this->db->get();
                $prevresult = $query->result_array();
                foreach ($prevresult as $prd) {
                    $amt = $prd['qty'];
                    $this->db->set('qty', "qty+$amt", FALSE);
                    $this->db->where('pid', $prd['pid']);
                    $this->db->update('jsoft_products');
                }
            }
            if ($affect) $this->db->delete('jsoft_invoice_items', array('tid' => $id));
            $data = array('type' => 9, 'rid' => $id);
            $this->db->delete('jsoft_metadata', $data);
            if ($this->db->trans_complete()) {
                return true;
            } else {
                return false;
            }
        }
    }


    private function _get_datatables_query($opt = '')
    {
        $this->db->select('jsoft_invoices.id, CONCAT(serie.serie, "-",jsoft_invoices.tid) AS serie,jsoft_invoices.invoicedate,jsoft_invoices.sunat,jsoft_invoices.respuesta,jsoft_invoices.invoiceduedate,jsoft_invoices.total,jsoft_invoices.status,jsoft_customers.name, jsoft_invoices.nomarchivo, jsoft_invoices.tipocomprobante');
        $this->db->from($this->table);
        $this->db->join('serie', 'jsoft_invoices.idserie = serie.id');
        $this->db->where('jsoft_invoices.i_class', 1);
        $this->db->where('jsoft_invoices.tipocomprobante<>', 'N');
        
        if ($this->input->post('sunat') === 'Todos')
        {
            
        }else{
            $this->db->where('jsoft_invoices.sunat', $this->input->post('sunat'));
        }
        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        if ($this->input->post('start_date') && $this->input->post('end_date')) // if datatable send POST for search
        {
            $this->db->where('DATE(jsoft_invoices.invoicedate) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_invoices.invoicedate) <=', datefordatabase($this->input->post('end_date')));
            
        }
        if($this->input->post('yeara')){
            $this->db->where('YEAR(jsoft_invoices.invoicedate)', $this->input->post('yeara')); 
        }
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd=jsoft_customers.id', 'left');

        $i = 0;

        foreach ($this->column_search as $item) // loop column
        {
            if ($this->input->post('search')['value']) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables($opt = '')
    {
        $this->_get_datatables_query($opt);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        $this->db->where('jsoft_invoices.i_class', 1);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 1);
        }

        return $query->result();
    }
    function count_filtered($opt = '')
    {
        $this->_get_datatables_query($opt);
        if ($opt) {
            $this->db->where('eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($opt = '')
    {
        $this->db->select('jsoft_invoices.id');
        $this->db->from($this->table);
        $this->db->where('jsoft_invoices.i_class', 1);
        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        return $this->db->count_all_results();
    }

    private function _get_datatables_query_resumen($opt = '')
    {
        $this->db->select('jsoft_invoices.id, CONCAT(serie.serie, "-",jsoft_invoices.tid) AS serie,jsoft_invoices.invoicedate,jsoft_invoices.sunat,jsoft_invoices.respuesta,jsoft_invoices.invoiceduedate,jsoft_invoices.total,jsoft_invoices.status,jsoft_customers.name, jsoft_invoices.nomarchivo, jsoft_invoices.tipocomprobante');
        $this->db->from($this->table);
        $this->db->join('serie', 'jsoft_invoices.idserie = serie.id');
        $this->db->where('jsoft_invoices.i_class', 1);
        $this->db->where('jsoft_invoices.tipocomprobante', 'B');
        $this->db->where('jsoft_invoices.idserie', '3');
        $this->db->where('jsoft_invoices.sunat', 'Guardado');
        $this->db->or_where('jsoft_invoices.sunat', 'Anulado');
        $this->db->where('jsoft_invoices.respuesta', null);

        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        if ($this->input->post('start_date')) // if datatable send POST for search
        {
            $originalDate = $this->input->post('start_date');
            $newDate = date("Y-m-d", strtotime($originalDate));
            $this->db->where('DATE(jsoft_invoices.invoicedate) =', $newDate);
        }
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd=jsoft_customers.id', 'left');

        $i = 0;

        foreach ($this->column_search as $item) // loop column
        {
            if ($this->input->post('search')['value']) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables_resumen($opt = '')
    {
        $this->_get_datatables_query_resumen($opt);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $this->db->where('jsoft_invoices.tipocomprobante', 'B');
        $this->db->where('jsoft_invoices.idserie', '3');
        $this->db->where('jsoft_invoices.sunat', 'Guardado');
        $this->db->or_where('jsoft_invoices.sunat', 'Anulado');
        $this->db->where('jsoft_invoices.respuesta', null);

        $query = $this->db->get();
        $this->db->where('jsoft_invoices.i_class', 1);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 1);
        }

        return $query->result();
    }

    function count_filtered_res($opt = '')
    {
        $this->_get_datatables_query_resumen($opt);
        if ($opt) {
            $this->db->where('eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        $this->db->where('jsoft_invoices.tipocomprobante', 'B');
        $this->db->where('jsoft_invoices.idserie', '3');
        $this->db->where('jsoft_invoices.sunat', 'Guardado');
        $this->db->or_where('jsoft_invoices.sunat', 'Anulado');
        $this->db->where('jsoft_invoices.respuesta', null);

        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all_res($opt = '')
    {
        $this->db->select('jsoft_invoices.id');
        $this->db->from($this->table);
        $this->db->where('jsoft_invoices.i_class', 1);
        $this->db->where('jsoft_invoices.tipocomprobante', 'B');
        $this->db->where('jsoft_invoices.idserie', '3');
        $this->db->where('jsoft_invoices.sunat', 'Guardado');
        $this->db->or_where('jsoft_invoices.sunat', 'Anulado');
        $this->db->where('jsoft_invoices.respuesta', null);

        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        return $this->db->count_all_results();
    }



    private function _get_datatables_query_nota($opt = '')
    {
        $this->db->select('jsoft_invoices.id, CONCAT(serie.serie, "-",jsoft_invoices.tid) AS serie,jsoft_invoices.invoicedate,jsoft_invoices.sunat,jsoft_invoices.respuesta,jsoft_invoices.invoiceduedate,jsoft_invoices.total,jsoft_invoices.status,jsoft_customers.name, jsoft_invoices.nomarchivo, jsoft_invoices.tipocomprobante');
        $this->db->from($this->table);
        $this->db->join('serie', 'jsoft_invoices.idserie = serie.id');
        $this->db->where('jsoft_invoices.i_class', 1);
        $this->db->where('jsoft_invoices.tipocomprobante', 'N');
        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        if ($this->input->post('start_date') && $this->input->post('end_date')) // if datatable send POST for search
        {
            $this->db->where('DATE(jsoft_invoices.invoicedate) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_invoices.invoicedate) <=', datefordatabase($this->input->post('end_date')));
        }
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd=jsoft_customers.id', 'left');

        $i = 0;

        foreach ($this->column_search as $item) // loop column
        {
            if ($this->input->post('search')['value']) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables_nota($opt = '')
    {
        $this->_get_datatables_query_nota($opt);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        $this->db->where('jsoft_invoices.i_class', 1);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 1);
        }

        return $query->result();
    }

    function count_filtered_nota($opt = '')
    {
        $this->_get_datatables_query_nota($opt);
        if ($opt) {
            $this->db->where('eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all_nota($opt = '')
    {
        $this->db->select('jsoft_invoices.id');
        $this->db->from($this->table);
        $this->db->where('jsoft_invoices.i_class', 1);
        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_invoices.loc', 0);
        }
        return $this->db->count_all_results();
    }

    private function _get_datatables_query_conting($opt = '')
    {
        $this->db->select('jsoft_contingencia.id,CONCAT(idserie, "-",jsoft_contingencia.tid) AS serie,jsoft_contingencia.invoicedate,jsoft_contingencia.invoiceduedate,jsoft_contingencia.total,jsoft_contingencia.status,jsoft_contingencia.sunat,jsoft_customers.name');
        $this->db->from('jsoft_contingencia');
        $this->db->where('jsoft_contingencia.i_class', 1);
        if ($opt) {
            $this->db->where('jsoft_contingencia.eid', $opt);
        }
        if ($this->input->post('start_date') && $this->input->post('end_date')) // si la tabla de datos envía POST para la búsqueda
        {
            $this->db->where('DATE(jsoft_contingencia.invoicedate) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_contingencia.invoicedate) <=', datefordatabase($this->input->post('end_date')));
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_contingencia.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_contingencia.loc', 0);
        }
        $this->db->join('jsoft_customers', 'jsoft_contingencia.csd=jsoft_customers.id', 'left');

        $i = 0;

        foreach ($this->column_search_cont as $item) // columna de bucle
        {
            if ($this->input->post('search')['value']) // si la tabla de datos envía POST para la búsqueda
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // soporte abierto. consulta WHERE con la cláusula OR mejor con corchetes. porque tal vez se pueda combinar con otros WHERE con AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search_cont) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // aquí procesamiento de ORDER
        {
            $this->db->order_by($this->column_order_conting[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order_conting)) {
            $order = $this->order_conting;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }


    function get_datatables_conting($opt = '')
    {
        $this->_get_datatables_query_conting($opt);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);

        $query = $this->db->get();
        $this->db->where('jsoft_contingencia.i_class', 1);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_contingencia.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_contingencia.loc', 0);
        }
        return $query->result();
    }


    function count_filtered_cont($opt = '')
    {
        $this->_get_datatables_query_conting($opt);
        if ($opt) {
            $this->db->where('eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_contingencia.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_contingencia.loc', 0);
        }
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all_cont($opt = '')
    {
        $this->db->select('jsoft_contingencia.id');
        $this->db->from('jsoft_contingencia');
        $this->db->where('jsoft_contingencia.i_class', 1);
        if ($opt) {
            $this->db->where('jsoft_contingencia.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_contingencia.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_contingencia.loc', 0);
        }
        return $this->db->count_all_results();
    }

    public function billingterms()
    {
        $this->db->select('id,title');
        $this->db->from('jsoft_terms');
        $this->db->where('type', 1);
        $this->db->or_where('type', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function convert($id)
    {
        $this->load->helper('convertir');
        $idserie = $this->input->post('serie');
        $idtipocomprobante = $this->input->post('comprobante');
        $iddoc = $this->input->post('tipodoc');
        $cliente_id = $this->input->post('customer_id');
        $invoices = $this->invoice_details($id);

        $products = $this->invoice_products($id);

        $total_tax = 0;
        $invocieno = $this->lastinvoice($idtipocomprobante, $idserie);
        $this->db->trans_start();

        $loc = location($this->aauth->get_user()->loc);
        $mon = $invoices['moneda'];

        $productlist = array();
        $prodindex = 0;
        if ($invoices['loc'] == $this->aauth->get_user()->loc) {
            $data1 = array('idserie' => $idserie, 'tid' => $invocieno, 'tipocomprobante' => $idtipocomprobante, 'iddoc' => $iddoc,  'invoicedate' => date("Y-m-d H:i:s"), 'invoiceduedate' => date("Y-m-d H:i:s"), 'subtotal' => $invoices['subtotal'], 'shipping' => $invoices['shipping'], 'discount' => $invoices['discount'], 'tax' => $invoices['tax'], 'total' => $invoices['total'], 'pmethod' => $invoices['pmethod'], 'notes' => $invoices['notes'], 'status' => $invoices['status'], 'idtipooperacion' => '0101', 'csd' => $cliente_id, 'eid' => $invoices['eid'], 'pamnt' => $invoices['subtotal'], 'items' => $invoices['items'], 'taxstatus' => $invoices['taxstatus'], 'discstatus' => $invoices['discstatus'], 'format_discount' => $invoices['format_discount'], 'refer' => $invoices['refer'], 'term' => $invoices['term'], 'multi' => $invoices['multi'], 'loc' => $invoices['loc'], 'i_class' => 1, 'icbper' => '0', 'efectivo' => $invoices['efectivo'], 'vuelto' => $invoices['vuelto'], 'moneda' => $invoices['moneda']);
            $this->db->insert('jsoft_invoices', $data1);
            $iid = $this->db->insert_id();
            $bill_date = datefordatabase($invoices['invoicedate']);
            foreach ($products as $row) {
                $amt = $row['qty'];

                $total_tax += numberClean($row['totaltax']);
                $data = array(
                    'idserie' => $idserie,
                    'tid' => $iid,
                    'tipocomprobante' => $idtipocomprobante,
                    'idtipoprecio' => $row['idtipoprecio'],
                    'idtipoafectacion' => $row['idtipoafectacion'],
                    'pid' => $row['pid'],
                    'product' => $row['product'],
                    'code' => $row['code'],
                    'qty' => $amt,
                    'price' => $row['price'],
                    'tax' => $row['tax'],
                    'discount' => $row['discount'],
                    'subtotal' => $row['subtotal'],
                    'totaltax' => $row['totaltax'],
                    'totaldiscount' => $row['totaldiscount'],
                    'product_des' => $row['product_des'],
                    'unit' => $row['unit'],
                    'icbper' => $row['icbper'],
                    'codsunat' => $loc['codigosunat'],
                );
                $productlist[$prodindex] = $data;
                $prodindex++;
            }
            $this->db->insert_batch('jsoft_invoice_items', $productlist);

            //Creacion de Xml para envío a SUNAT
            $totaletras = num_to_letras($invoices['total'], $mon);

            $this->db->select('*');
            $this->db->from('jsoft_customers');
            $this->db->where('id', $cliente_id);
            $queryr = $this->db->get();
            $result_cus = $queryr->row_array();

            $this->db->select('*');
            $this->db->from('tipocomprobante');
            $this->db->where('idtipocomprobante', $idtipocomprobante);
            $queryt = $this->db->get();
            $result_comp = $queryt->row_array();

            $this->db->select('*');
            $this->db->from('serie');
            $this->db->where('id', $idserie);
            $queryserie = $this->db->get();
            $result_serie = $queryserie->row_array();


            $codley = '2001';
            $leyenda = 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA';

            $subtotal = $invoices['subtotal'];
            $total = $invoices['total'];

            $util = Util::getInstance();
            if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {

                // Cliente
                $client = new Client();
                $client->setTipoDoc($iddoc)
                    ->setNumDoc($result_cus['numdoc'])
                    ->setRznSocial($result_cus['name'])
                    ->setAddress((new Address())
                        ->setDireccion($result_cus['address']))
                    ->setEmail($result_cus['email'])
                    ->setTelephone($result_cus['phone']);
                // Venta
                $invoice = new Invoice();
                $invoice
                    ->setUblVersion('2.1')
                    ->setTipoOperacion('0101')
                    ->setTipoDoc($result_comp['numtipo_comprobante'])
                    ->setSerie($result_serie['serie'])
                    ->setCorrelativo($invocieno)
                    ->setFechaEmision(new DateTime($bill_date))
                    ->setFormaPago(new FormaPagoContado())
                    ->setTipoMoneda($mon)
                    ->setCompany((new Company())
                        ->setRuc($loc['ruc'])
                        ->setNombreComercial($loc['ncomercial'])
                        ->setRazonSocial($loc['cname'])
                        ->setAddress((new Address())
                            ->setUbigueo($loc['ubigeo'])
                            ->setDistrito($loc['city'])
                            ->setProvincia($loc['region'])
                            ->setDepartamento($loc['country'])
                            ->setUrbanizacion('NONE')
                            ->setCodLocal($loc['codlocal'])
                            ->setDireccion($loc['address']))
                        ->setEmail($loc['email'])
                        ->setTelephone($loc['phone']))
                    ->setClient($client)
                    ->setMtoOperGravadas(0)
                    ->setMtoOperExoneradas($subtotal)
                    ->setMtoIGV($total_tax)
                    ->setIcbper(0)
                    ->setTotalImpuestos($total_tax + 0)
                    ->setValorVenta($subtotal)
                    ->setSubTotal($subtotal)
                    ->setMtoImpVenta($total);

                $detalles = [];
                foreach ($productlist as $detail) {
                    $items = new SaleDetail();
                    $items->setCodProducto($detail['code'])
                        ->setUnidad($detail['unit'])
                        ->setCantidad($detail['qty'])
                        ->setDescripcion($detail['product'])
                        ->setMtoValorUnitario($detail['price'])
                        ->setMtoPrecioUnitario($detail['price'])
                        ->setCodProdSunat($loc['codigosunat'])
                        ->setMtoValorVenta($detail['subtotal'])
                        ->setTipAfeIgv($detail['idtipoafectacion'])
                        ->setMtoBaseIgv($detail['subtotal'])
                        ->setPorcentajeIgv($detail['tax'])
                        ->setIgv($detail['totaltax'])
                        ->setIcbper(($detail['qty']) * (0)) // (cantidad)*(factor ICBPER)
                        ->setFactorIcbper($loc['icbper'])
                        ->setTotalImpuestos(($detail['totaltax']) + ($detail['qty']) * ($detail['icbper']));
                    $detalles[] = $items;
                }

                $invoice->setDetails($detalles)
                    ->setLegends([
                        (new Legend())
                            ->setCode('1000')
                            ->setValue($totaletras),
                        (new Legend())
                            ->setCode($codley)
                            ->setValue($leyenda)
                        //(new Legend())
                        //->setCode('2004')
                        //->setValue('Agencia de Viaje - Paquete turístico')
                    ]);

                // Envio a SUNAT.
                $rutacert = '/../resources/' . $loc['certificado'];
                $ruc = $loc['ruc'];
                $usuario = $loc['usuariosol'];
                $sol = $loc['clavesol'];
                if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                    $modo = SunatEndpoints::FE_PRODUCCION;
                } else {
                    $modo = SunatEndpoints::FE_BETA;
                    $ruc = '10770468341';

                    $usuario = 'MODDATOS';
                    $sol = 'moddatos';
                }
                $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                $xml = $see->getXmlSigned($invoice);
                $util->writeXml($invoice, $xml);
                $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                $filename = $invoice->getName();
                $this->db->set(array('sunat' => 'Guardado', 'hash' => $hash, 'nomarchivo' => $filename));
                $this->db->where('id', $iid);
                $this->db->update('jsoft_invoices');
            }

            $this->db->trans_complete();



            return true;
        } else {
            $this->db->trans_rollback();
            return false;
        }
    }

    public function cargarserie($param)
    {
        $this->db->select('id,serie');
        $this->db->from('serie');
        $this->db->where('idtipocomprobante', $param);
        $this->db->where('loc', $this->aauth->get_user()->loc);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function tipocomprobante()
    {
        $this->db->select('idtipocomprobante,nombre_docu');
        $this->db->from('tipocomprobante');
        $this->db->where('numtipo_comprobante', '03');
        $this->db->or_where('numtipo_comprobante', '01');
        $this->db->or_where('numtipo_comprobante', '00');
        $this->db->order_by('idtipocomprobante', 'ASC');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function listartipodoc()
    {
        $this->db->select('id,descripcion');
        $this->db->from('documentoidentidad');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function listartipooperacion()
    {
        $this->db->select('id,descripcion');
        $this->db->from('tipooperacion');
        $query = $this->db->get();
        return $query->result_array();
    }



    public function employee($id)
    {
        $this->db->select('jsoft_employees.name,jsoft_employees.sign,jsoft_users.roleid');
        $this->db->from('jsoft_employees');
        $this->db->where('jsoft_employees.id', $id);
        $this->db->join('jsoft_users', 'jsoft_employees.id = jsoft_users.id', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function meta_insert($id, $type, $meta_data)
    {

        $data = array('type' => $type, 'rid' => $id, 'col1' => $meta_data);
        if ($id) {
            return $this->db->insert('jsoft_metadata', $data);
        } else {
            return 0;
        }
    }

    public function attach($id)
    {
        $this->db->select('jsoft_metadata.*');
        $this->db->from('jsoft_metadata');
        $this->db->where('jsoft_metadata.type', 1);
        $this->db->where('jsoft_metadata.rid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function meta_delete($id, $type, $name)
    {
        if (@unlink(FCPATH . 'userfiles/attach/' . $name)) {
            return $this->db->delete('jsoft_metadata', array('rid' => $id, 'type' => $type, 'col1' => $name));
        }
    }

    public function gateway_list($enable = '')
    {

        $this->db->from('jsoft_gateways');
        if ($enable == 'Yes') {
            $this->db->where('enable', 'Yes');
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function drafts()
    {


        $this->db->select('jsoft_draft.id,jsoft_draft.tid,jsoft_draft.invoicedate');
        $this->db->from('jsoft_draft');
        $this->db->where('jsoft_draft.loc', $this->aauth->get_user()->loc);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(12);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function draft_products($id)
    {

        $this->db->select('*');
        $this->db->from('jsoft_draft_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function cliente_det()
    {
        $this->db->select('*');
        $this->db->from('jsoft_customers');
        $this->db->where('iddoc', '0');
        $this->db->where('numdoc', '99999999');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function draft_details($id, $eid = '')
    {

        $this->db->select('jsoft_draft.*,SUM(jsoft_draft.shipping + jsoft_draft.ship_tax) AS shipping,jsoft_customers.*,jsoft_customers.id AS cid,jsoft_draft.id AS iid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms');
        $this->db->from('jsoft_draft');
        $this->db->where('jsoft_draft.id', $id);
        if ($eid) {
            $this->db->where('jsoft_draft.eid', $eid);
        }
        $this->db->join('jsoft_customers', 'jsoft_draft.csd = jsoft_customers.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_draft.term', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function accountslist()
    {
        $this->db->select('*');
        $this->db->from('jsoft_accounts');

        if ($this->aauth->get_user()->loc) {
            $this->db->where('loc', $this->aauth->get_user()->loc);
            if (BDATA) $this->db->or_where('loc', 0);
        } else {
            if (!BDATA) $this->db->where('loc', 0);
        }

        $query = $this->db->get();
        return $query->result_array();
    }
}
