<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Purchase_model extends CI_Model
{
    var $table = 'jsoft_purchase';
    var $column_order = array(null, 'jsoft_purchase.tid', 'jsoft_supplier.name', 'jsoft_purchase.invoicedate', 'jsoft_purchase.total', 'jsoft_purchase.status', null);
    var $column_search = array('jsoft_purchase.tid', 'jsoft_supplier.name', 'jsoft_purchase.invoicedate', 'jsoft_purchase.total','jsoft_purchase.status');
    var $order = array('jsoft_purchase.tid' => 'desc');

    public function __construct()
    {
        parent::__construct();
    }

    public function lastpurchase()
    {
        $this->db->select('tid');
        $this->db->from($this->table);
        $this->db->order_by('tid', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->tid;
        } else {
            return 1000;
        }
    }

    public function warehouses()
    {
        $this->db->select('*');
        $this->db->from('jsoft_warehouse');
        if ($this->aauth->get_user()->loc) {
            $this->db->where('loc', $this->aauth->get_user()->loc);
            if (BDATA) $this->db->or_where('loc', 0);
        } elseif (!BDATA) {
            $this->db->where('loc', 0);
        }
        $query = $this->db->get();
        return $query->result_array();

    }
    
    public function docref()
    {
        $this->db->select('*');
        $this->db->from('jsoft_docreferencia');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function concepto()
    {
        $this->db->select('*');
        $this->db->from('jsoft_concepto');   
        $this->db->where('tipo','I');   
        $query = $this->db->get();
        return $query->result_array();

    }

    public function purchase_details($id)
    {

        $this->db->select('jsoft_purchase.*,jsoft_purchase.id AS iid,SUM(jsoft_purchase.shipping + jsoft_purchase.ship_tax) AS shipping,jsoft_supplier.*,jsoft_supplier.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms');
        $this->db->from($this->table);
        $this->db->where('jsoft_purchase.id', $id);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_purchase.loc', $this->aauth->get_user()->loc);
            if (BDATA) $this->db->or_where('jsoft_purchase.loc', 0);
        } elseif (!BDATA) {
            $this->db->where('jsoft_purchase.loc', 0);
        }
        $this->db->join('jsoft_supplier', 'jsoft_purchase.csd = jsoft_supplier.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_purchase.term', 'left');
        $query = $this->db->get();
        return $query->row_array();

    }

    public function purchase_products($id)
    {
        $this->db->select('*');
        $this->db->from('jsoft_purchase_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function purchase_transactions($id)
    {
        $this->db->select('*');
        $this->db->from('jsoft_transactions');
        $this->db->where('tid', $id);
        $this->db->where('ext', 1);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function purchase_delete($id)
    {
        $this->db->trans_start();
        $this->db->select('pid,qty');
        $this->db->from('jsoft_purchase_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        $prevresult = $query->result_array();
        foreach ($prevresult as $prd) {
            $amt = $prd['qty'];
            $this->db->set('qty', "qty-$amt", FALSE);
            $this->db->where('pid', $prd['pid']);
            $this->db->update('jsoft_products');
        }
        $whr = array('id' => $id);
        if ($this->aauth->get_user()->loc) {
            $whr = array('id' => $id, 'loc' => $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
               $whr = array('id' => $id, 'loc' =>0);
        }
        $this->db->delete('jsoft_purchase', $whr);
        if ($this->db->affected_rows()) $this->db->delete('jsoft_purchase_items', array('tid' => $id));
        if ($this->db->trans_complete()) {
            return true;
        } else {
            return false;
        }
    }


    private function _get_datatables_query()
    {
        $this->db->select('jsoft_purchase.id,jsoft_purchase.tid,jsoft_purchase.invoicedate,jsoft_purchase.invoiceduedate,jsoft_purchase.total,jsoft_purchase.status,jsoft_supplier.name');
        $this->db->from($this->table);
        $this->db->join('jsoft_supplier', 'jsoft_purchase.csd=jsoft_supplier.id', 'left');
            if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_purchase.loc', $this->aauth->get_user()->loc);
        }
        elseif(!BDATA) { $this->db->where('jsoft_purchase.loc', 0); }
                    if ($this->input->post('start_date') && $this->input->post('end_date')) // if datatable send POST for search
        {
            $this->db->where('DATE(jsoft_purchase.invoicedate) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_purchase.invoicedate) <=', datefordatabase($this->input->post('end_date')));
        }
        $i = 0;
        foreach ($this->column_search as $item) // loop column
        {
            if ($this->input->post('search')['value']) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->from($this->table);
           if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_purchase.loc', $this->aauth->get_user()->loc);
        }
        elseif(!BDATA) { $this->db->where('jsoft_purchase.loc', 0); }
        return $this->db->count_all_results();
    }


    public function billingterms()
    {
        $this->db->select('id,title');
        $this->db->from('jsoft_terms');
        $this->db->where('type', 4);
        $this->db->or_where('type', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function currencies()
    {

        $this->db->select('*');
        $this->db->from('jsoft_currencies');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function currency_d($id)
    {
        $this->db->select('*');
        $this->db->from('jsoft_currencies');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function employee($id)
    {
        $this->db->select('jsoft_employees.name,jsoft_employees.sign,jsoft_users.roleid');
        $this->db->from('jsoft_employees');
        $this->db->where('jsoft_employees.id', $id);
        $this->db->join('jsoft_users', 'jsoft_employees.id = jsoft_users.id', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function meta_insert($id, $type, $meta_data)
    {

        $data = array('type' => $type, 'rid' => $id, 'col1' => $meta_data);
        if ($id) {
            return $this->db->insert('jsoft_metadata', $data);
        } else {
            return 0;
        }
    }

    public function attach($id)
    {
        $this->db->select('jsoft_metadata.*');
        $this->db->from('jsoft_metadata');
        $this->db->where('jsoft_metadata.type', 4);
        $this->db->where('jsoft_metadata.rid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function meta_delete($id, $type, $name)
    {
        if (@unlink(FCPATH . 'userfiles/attach/' . $name)) {
            return $this->db->delete('jsoft_metadata', array('rid' => $id, 'type' => $type, 'col1' => $name));
        }
    }

}