<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Stockreturn_model extends CI_Model {

    var $table = 'jsoft_stock_r';
    var $tablecomb = 'jsoft_comunicacion_baja';
    var $column_order = array(null, 'jsoft_stock_r.tid', 'name', 'jsoft_stock_r.invoicedate', 'jsoft_stock_r.total', 'jsoft_stock_r.status', null);
    var $column_search = array('jsoft_stock_r.tid', 'name', 'jsoft_stock_r.invoicedate', 'jsoft_stock_r.total', 'jsoft_stock_r.status');
    var $order = array('jsoft_stock_r.tid' => 'desc');
    var $ordercomb = array('jsoft_comunicacion_baja.idcom' => 'desc');
    var $column_ordercomb = array(null, 'jsoft_comunicacion_baja.idcom', 'jsoft_customers.name', 'jsoft_comunicacion_baja.fechaemision', 'jsoft_comunicacion_baja.motivo', 'jsoft_comunicacion_baja.respuestasunat', 'jsoft_comunicacion_baja.ticket', 'jsoft_comunicacion_baja.estadosunat','jsoft_comunicacion_baja.nomarchivo', null);
    var $column_searchcomb = array('jsoft_comunicacion_baja.idcom', 'jsoft_comunicacion_baja.idinvoice', 'jsoft_comunicacion_baja.motivo');

    public function __construct() {
        parent::__construct();
    }

    public function lastpurchase($param, $param2) {
        $this->db->select('tid');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $this->db->where('i_class', 2);
        $this->db->where('tipocomprobante', $param);
        $this->db->where('idserie', $param2);

        $query = $this->db->get()->result();
        if (empty($query)) {
            $n = "00000001";
            return $n;
        } else {
            foreach ($query as $obj) {
                $correlativo = $obj->tid;
            }
            $n = intval($correlativo) + 1;
            if (strlen($n) >= 8) {
                return $n;
            }
            $numerodeceros = 8 - strlen($n);
            for ($i = 0; $i < $numerodeceros; $i++) {
                $n = "0" . $n;
            }
            return $n;
        }
    }

    public function warehouses() {
        $this->db->select('*');
        $this->db->from('jsoft_warehouse');
        if ($this->aauth->get_user()->loc) {
            $this->db->where('loc', $this->aauth->get_user()->loc);
            if (BDATA)
                $this->db->or_where('loc', 0);
        } elseif (!BDATA) {
            $this->db->where('loc', 0);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargarserie($param) {
        $this->db->select('id,serie');
        $this->db->from('serie');
        $this->db->where('idtipocomprobante', $param);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function listartipoprecio() {
        $this->db->select('id,descripcion');
        $this->db->from('tipoprecio');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function listartipoafectacion() {
        $this->db->select('id,descripcion');
        $this->db->from('tipoafectacion');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function listar_productos($param) {
        $this->db->select('*,ta.descripcion as afectacion, tp.descripcion as tipoprecio');
        $this->db->from('jsoft_invoice_items ci');
        $this->db->join('tipoafectacion ta', 'ci.idtipoafectacion = ta.id');
        $this->db->join('tipoprecio tp', 'ci.idtipoprecio = tp.id');
        $this->db->where('tid', $param);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function listar_comprobantes($param) {
        $this->db->select('*');
        $this->db->from('jsoft_invoices');
        $this->db->where('id', $param);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function listar_cliente($param) {
        $this->db->select('*');
        $this->db->from('jsoft_invoices i');
        $this->db->join('jsoft_customers c', 'i.csd = c.id');
        $this->db->where('i.id', $param);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function currencies() {

        $this->db->select('*');
        $this->db->from('jsoft_currencies');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function listartipooperacion() {
        $this->db->select('id,descripcion');
        $this->db->from('tipooperacion');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function purchase_details($id) {

        $this->db->select('jsoft_stock_r.i_class');
        $this->db->from($this->table);
        $this->db->join('serie s', 'jsoft_stock_r.idserie = s.id');
        $this->db->join('tipocomprobante tc', 'jsoft_stock_r.tipocomprobante = tc.idtipocomprobante');
        $this->db->where('jsoft_stock_r.id', $id);
        $query = $this->db->get();
        $out = $query->row_array();

        if ($out['i_class']) {
            $this->db->select('jsoft_stock_r.*, s.serie,jsoft_stock_r.id AS iid,SUM(jsoft_stock_r.shipping + jsoft_stock_r.ship_tax) AS shipping,jsoft_customers.*,jsoft_stock_r.loc as loc,jsoft_customers.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms, tc.numtipo_comprobante');
            $this->db->from($this->table);
            $this->db->where('jsoft_stock_r.id', $id);
            $this->db->join('serie s', 'jsoft_stock_r.idserie = s.id');
            $this->db->join('tipocomprobante tc', 'jsoft_stock_r.tipocomprobante = tc.idtipocomprobante');
            $this->db->join('jsoft_customers', 'jsoft_stock_r.csd = jsoft_customers.id', 'left');
            $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_stock_r.term', 'left');
            if ($this->aauth->get_user()->loc) {
                $this->db->where('jsoft_stock_r.loc', $this->aauth->get_user()->loc);
            } elseif (!BDATA) {
                $this->db->where('jsoft_stock_r.loc', 0);
            }
            $query = $this->db->get();
            return $query->row_array();
        } else {

            $this->db->select('jsoft_stock_r.*, s.serie,jsoft_stock_r.id AS iid,SUM(jsoft_stock_r.shipping + jsoft_stock_r.ship_tax) AS shipping,jsoft_supplier.*,jsoft_stock_r.loc as loc,jsoft_supplier.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms');
            $this->db->from($this->table);
            $this->db->where('jsoft_stock_r.id', $id);
            $this->db->join('serie s', 'jsoft_stock_r.idserie = s.id');
            $this->db->join('jsoft_supplier', 'jsoft_stock_r.csd = jsoft_supplier.id', 'left');
            $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_stock_r.term', 'left');
            if ($this->aauth->get_user()->loc) {
                $this->db->where('jsoft_stock_r.loc', $this->aauth->get_user()->loc);
            } elseif (!BDATA) {
                $this->db->where('jsoft_stock_r.loc', 0);
            }
            $query = $this->db->get();
            return $query->row_array();
        }
    }

    public function purchase_products($id) {

        $this->db->select('*');
        $this->db->from('jsoft_stock_r_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function purchase_transactions($id) {

        $this->db->select('*');
        $this->db->from('jsoft_transactions');
        $this->db->where('tid', $id);
        $this->db->where('ext', 6);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function purchase_delete($id) {

        $this->db->trans_start();

        $this->db->select('pid,qty');
        $this->db->from('jsoft_stock_r_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        $prevresult = $query->result_array();

        $this->db->select('i_class');
        $this->db->from('jsoft_stock_r');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $stock = $query->row_array();
        if (($stock['i_class'] != 2 && $this->aauth->premission(2)) OR ($stock['i_class'] == 2 && $this->aauth->premission(1))) {
            foreach ($prevresult as $prd) {
                $amt = $prd['qty'];
                $this->db->set('qty', "qty+$amt", FALSE);
                $this->db->where('pid', $prd['pid']);
                $this->db->update('jsoft_products');
            }
            $whr = array('id' => $id);
            if ($this->aauth->get_user()->loc) {
                $whr = array('id' => $id, 'loc' => $this->aauth->get_user()->loc);
            }
            $this->db->delete('jsoft_stock_r', $whr);
            if ($this->db->affected_rows())
                $this->db->delete('jsoft_stock_r_items', array('tid' => $id));
            if ($this->db->trans_complete()) {
                return true;
            } else {
                return false;
            }
        }
    }

    private function _get_datatables_query($type = 0) {
        if ($type) {

            $this->db->select('jsoft_stock_r.id,CONCAT(serie.serie, "-",jsoft_stock_r.tid) AS tid,jsoft_stock_r.invoicedate,jsoft_stock_r.invoiceduedate,jsoft_stock_r.total,jsoft_stock_r.status,jsoft_customers.name,jsoft_stock_r.refer, jsoft_stock_r.sunat');
            $this->db->from($this->table);
            $this->db->where('jsoft_stock_r.i_class', $type);
            $this->db->join('jsoft_customers', 'jsoft_stock_r.csd=jsoft_customers.id', 'left');
            $this->db->join('serie', 'jsoft_stock_r.idserie=serie.id');
            if ($this->aauth->get_user()->loc) {
                $this->db->where('jsoft_stock_r.loc', $this->aauth->get_user()->loc);
            } elseif (!BDATA) {
                $this->db->where('jsoft_stock_r.loc', 0);
            }
        } else {
            $this->db->select('jsoft_stock_r.id,jsoft_stock_r.tid,jsoft_stock_r.invoicedate,jsoft_stock_r.invoiceduedate,jsoft_stock_r.total,jsoft_stock_r.status,jsoft_supplier.name');
            $this->db->from($this->table);
            $this->db->where('jsoft_stock_r.i_class', $type);
            $this->db->join('jsoft_supplier', 'jsoft_stock_r.csd=jsoft_supplier.id', 'left');
            if ($this->aauth->get_user()->loc) {
                $this->db->where('jsoft_stock_r.loc', $this->aauth->get_user()->loc);
            } elseif (!BDATA) {
                $this->db->where('jsoft_stock_r.loc', 0);
            }
        }
        if ($this->input->post('start_date') && $this->input->post('end_date')) { // if datatable send POST for search
            $this->db->where('DATE(jsoft_stock_r.invoicedate) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_stock_r.invoicedate) <=', datefordatabase($this->input->post('end_date')));
        }
        $i = 0;

        foreach ($this->column_search as $item) { // loop column

            if ($this->input->post('search')['value']) { // if datatable send POST for search

                if ($i === 0) { // first loop
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) { // here order processing
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables($type = 0) {
        $this->_get_datatables_query($type);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);

        $query = $this->db->get();
        return $query->result();
    }

    private function _get_datatables_query_com_b($type = 0) {


        $this->db->select("jsoft_comunicacion_baja.idcom, jsoft_customers.numdoc, jsoft_customers.name, CONCAT(serie.serie,'-', jsoft_invoices.tid) referencia, jsoft_comunicacion_baja.fechaemision, jsoft_comunicacion_baja.motivo, jsoft_comunicacion_baja.ticket, jsoft_comunicacion_baja.estadosunat AS status, jsoft_invoices.total");
        $this->db->from($this->tablecomb);
        $this->db->join('jsoft_invoices', 'jsoft_comunicacion_baja.idinvoice=jsoft_invoices.id');
        $this->db->join('serie', 'jsoft_invoices.idserie=serie.id');
        $this->db->join('jsoft_customers', 'jsoft_customers.id=jsoft_invoices.csd');
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_comunicacion_baja.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_comunicacion_baja.loc', 0);
        }


        if ($this->input->post('start_date') && $this->input->post('end_date')) { // if datatable send POST for search
            $this->db->where('DATE(jsoft_comunicacion_baja.fechaemision) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_comunicacion_baja.fechaemision) <=', datefordatabase($this->input->post('end_date')));
        }
        $i = 0;

        foreach ($this->column_searchcomb as $item) { // loop column

            if ($this->input->post('search')['value']) { // if datatable send POST for search

                if ($i === 0) { // first loop
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_searchcomb) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) { // here order processing
            $this->db->order_by($this->column_ordercomb[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->ordercomb)) {
            $order = $this->ordercomb;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables_com_b($type = 0) {
        $this->_get_datatables_query_com_b($type);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);

        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered() {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function count_filtered_com_b() {
        $this->_get_datatables_query_com_b();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all() {
        $this->db->from($this->table);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_stock_r.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_stock_r.loc', 0);
        }
        return $this->db->count_all_results();
    }
    public function count_all_com_b() {
        $this->db->from($this->tablecomb);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_comunicacion_baja.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_comunicacion_baja.loc', 0);
        }
        return $this->db->count_all_results();
    }

    public function billingterms() {
        $this->db->select('id,title');
        $this->db->from('jsoft_terms');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function employee($id) {
        $this->db->select('jsoft_employees.name,jsoft_employees.sign,jsoft_users.roleid');
        $this->db->from('jsoft_employees');
        $this->db->where('jsoft_employees.id', $id);
        $this->db->join('jsoft_users', 'jsoft_employees.id = jsoft_users.id', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function meta_insert($id, $type, $meta_data) {

        $data = array('type' => $type, 'rid' => $id, 'col1' => $meta_data);
        if ($id) {
            return $this->db->insert('jsoft_metadata', $data);
        } else {
            return 0;
        }
    }

    public function attach($id) {
        $this->db->select('jsoft_metadata.*');
        $this->db->from('jsoft_metadata');
        $this->db->where('jsoft_metadata.type', 4);
        $this->db->where('jsoft_metadata.rid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function meta_delete($id, $type, $name) {
        if (@unlink(FCPATH . 'userfiles/attach/' . $name)) {
            return $this->db->delete('jsoft_metadata', array('rid' => $id, 'type' => $type, 'col1' => $name));
        }
    }

}
