<!doctype html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title>Imprimir Comprobante #<?php echo $invoice['tid'] ?></title>
        <style>
            body {
                color: #2B2000;
                font-family: 'Helvetica';
            }

            .invoice-box {
                width: 210mm;
                height: 297mm;
                margin: auto;
                padding: 4mm;
                border: 0;
                font-size: 10px;
                line-height: 14pt;
                color: #000;
            }

            table {
                width: 100%;
                line-height: 12pt;
                text-align: left;
                border-collapse: collapse;
            }

            .plist tr td {
                line-height: 1pt;
                font-size: 10px;
            }

            .subtotal {
                page-break-inside: avoid;
                margin-left: 480px; 
                margin-top: -110px; 
                width: 100%;
            }

            .subtotal tr td {
                line-height: 10pt;
                padding: 6pt;
            }

            .subtotal tr td {
                border: 0px solid #ddd;
            }

            .sign {
                text-align: right;
                font-size: 10px;
                margin-right: 110pt;
            }

            .sign1 {
                text-align: right;
                font-size: 10px;
                margin-right: 90pt;
            }

            .sign2 {
                text-align: right;
                font-size: 10px;
                margin-right: 115pt;
            }

            .sign3 {
                text-align: right;
                font-size: 10px;
                margin-right: 115pt;
            }

            .terms {
                font-size: 9px;
                line-height: 16pt;
                margin-right: 20pt;
            }

            .invoice-box table td {
                padding: 10pt 4pt 8pt 4pt;
                vertical-align: top;
            }

            .invoice-box table.top_sum td {
                padding: 0;
                font-size: 12px;
                
            }
            .top_sum{
                width: 200px;
                margin-left: 130px;
                margin-top: -100px
            }

            .party tr td:nth-child(3) {
                text-align: center;
            }

            .invoice-box table tr.top table td {
                padding-bottom: 20pt;
            }

            table tr.top table td.title {
                font-size: 45px;
                line-height: 45pt;
                color: #555;
            }

            table tr.information table td {
                padding-bottom: 20pt;
            }

            table tr.heading td {
                background: #515151;
                color: #FFF;
                padding: 6pt;
            }

            table tr.details td {
                padding-bottom: 20pt;
            }

            .invoice-box table tr.item td {
                border: 1px solid #ddd;
            }

            table tr.b_class td {
                border-bottom: 1px solid #ddd;
            }

            table tr.b_class.last td {
                border-bottom: none;
            }

            table tr.total td:nth-child(4) {
                border-top: 2px solid #fff;
                font-weight: bold;
            }

            .myco {
                width: 400pt;
            }

            .myco2 {
                width: 200pt;
            }

            .myw {
                width: 300pt;
                font-size: 14px;
                line-height: 14pt;
            }

            .mfill {
                background-color: #eee;
            }

            .descr {
                font-size: 8px;
                color: #515151;
            }

            .tax {
                font-size: 10px;
                color: #515151;
            }

            .t_center {
                text-align: right;
            }

            .party {
                border: #ccc 1px solid;
                font-size: 10px
            }

            .top_logo {
                max-height: 100px;
                max-width: 250px;
                <?php if (LTR == 'rtl') echo 'margin-left: 200px;' ?>
            }
            .leyenda {
                margin-left: 100px;
                margin-top: -90px;
                width: 460px;
            }

        </style>
    </head>
    <body dir="<?= LTR ?>">
        <div class="invoice-box">
            <br><br>
            <table class="party">
                <tbody>
                    <tr>        
                        <td>
                            <?php
                            echo '<strong>DNI/RUC:</strong> ' . $invoice['numdoc'] . '<br>  <strong>Cliente: </strong> ' . $invoice['name'] . '<br>';
                            if ($invoice['company'])
                                echo $invoice['company'] . '<br>';

                            echo $invoice['address'];
                            if (is_array($c_custom_fields)) {
                                echo '<br>';
                                foreach ($c_custom_fields as $row) {
                                    echo $row['name'] . ': ' . $row['data'] . '<br>';
                                }
                            }
                            ?>
                            </ul>
                        </td>
                        <td>
                            <?php
                            $loc = location($invoice['loc']);
                            if ($loc['currency'] == 'S/')
                                $mon = 'PEN';
                            else
                                $mon = 'USD';
                            echo '<strong>FECHA EMISIÓN:</strong> ' . $invoice['invoicedate'] . '<br>';
                            echo '<strong>FECHA DE VEN:</strong> ' . $invoice['invoiceduedate'] . '<br>';
                            echo '<strong>MONEDA:</strong> ' . $mon;
                            ;
                            if (is_array($c_custom_fields)) {
                                echo '<br>';
                                foreach ($c_custom_fields as $row) {
                                    echo $row['name'] . ': ' . $row['data'] . '<br>';
                                }
                            }
                            ?>
                            </ul>
                        </td>
                    </tr><?php if (@$invoice['name_s']) { ?>
                        <tr>
                            <td>
                                <?php
                                echo '<strong>' . $this->lang->line('Shipping Address') . '</strong>:<br>';
                                echo $invoice['name_s'] . '<br>';
                                echo $invoice['address_s'] . '<br>' . $invoice['city_s'] . ', ' . $invoice['region_s'];
                                if ($invoice['country_s'])
                                    echo '<br>' . $invoice['country_s'];
                                if ($invoice['postbox_s'])
                                    echo ' - ' . $invoice['postbox_s'];
                                if ($invoice['phone_s'])
                                    echo '<br>' . $this->lang->line('Phone') . ': ' . $invoice['phone_s'];
                                if ($invoice['email_s'])
                                    echo '<br> ' . $this->lang->line('Email') . ': ' . $invoice['email_s'];
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            
            <table class="plist" cellpadding="0" cellspacing="0">
                <tr class="heading">
                    <td style="width: 1rem;">
                        CANTIDAD
                    </td>
                    <td>
                        UM
                    </td>
                    <td>
                        DESCRIPCIÓN
                    </td>
                    <td>
                        P/U
                    </td>
                    <?php
                    if ($invoice['tax'] > 0)
                        echo '<td>' . $this->lang->line('Tax') . '</td>';
                    if ($invoice['discount'] > 0)
                        echo '<td>' . $this->lang->line('Discount') . '</td>';
                    ?>
                    <td class="t_center">
                        IMPORTE
                    </td>
                </tr>
                <?php
                $fill = true;
                $sub_t = 0;
                $sub_t_col = 3;
                $n = 1;
                $totalletras = "";
                foreach ($products as $row) {
                    $cols = 4;
                    if ($fill == true) {
                        $flag = ' mfill';
                    } else {
                        $flag = '';
                    }
                    $sub_t += $row['price'] * $row['qty'];

                    if ($row['serial'])
                        $row['product_des'] .= ' - ' . $row['serial'];
                    echo '<tr class="item' . $flag . '">  <td>' . +$row['qty'] . '</td>
                            <td>' . $row['unit'] . '</td>
                            <td>' . $row['product'] . '</td>
                            <td>' . amountExchange($row['price'], $invoice['multi'], $invoice['loc']) . '</td>   ';
                    if ($invoice['tax'] > 0) {
                        $cols++;
                        echo '<td style="width:16%;">' . amountExchange($row['totaltax'], $invoice['multi'], $invoice['loc']) . ' <span class="tax">(' . amountFormat_s($row['tax']) . '%)</span></td>';
                    }
                    if ($invoice['discount'] > 0) {
                        $cols++;
                        echo ' <td style="width:16%;">' . amountExchange($row['totaldiscount'], $invoice['multi'], $invoice['loc']) . '</td>';
                    }
                    echo '<td class="t_center">' . amountExchange($row['subtotal'], $invoice['multi'], $invoice['loc']) . '</td></tr>';

                    if ($row['product_des']) {
                        $cc = $cols++;

                        echo '<tr class="item' . $flag . ' descr">  <td> </td>
                            <td colspan="' . $cc . '">' . $row['product_des'] . '&nbsp;</td>
							
                        </tr>';
                    }
                    if (CUSTOM) {
                        $p_custom_fields = $this->custom->view_fields_data($row['pid'], 4, 1);

                        if (is_array($p_custom_fields[0])) {
                            $z_custom_fields = '';

                            foreach ($p_custom_fields as $row) {
                                $z_custom_fields .= $row['name'] . ': ' . $row['data'] . '<br>';
                            }

                            echo '<tr class="item' . $flag . ' descr">  <td> </td>
                            <td colspan="' . $cc . '">' . $z_custom_fields . '&nbsp;</td>
							
                        </tr>';
                        }
                    }
                    $fill = !$fill;
                    $n++;
                }

                if ($invoice['shipping'] > 0) {

                    $sub_t_col++;
                }
                if ($invoice['tax'] > 0) {
                    $sub_t_col++;
                }
                if ($invoice['discount'] > 0) {
                    $sub_t_col++;
                }
                ?>


            </table>
             
            <div class="terms"><?php echo $invoice['notes'] . '<hr>' . '<strong>SON: ' . num_to_letras($invoice['total'], $mon).'<strong>'; ?></div><br>
            <div class="barcodecell">
               <barcode code="<?php echo $qr; ?>" type="QR" class="barcode" size="0.9" error="Q" disableborder="1" /> 
            </div>
            <div style="font-size: 10px" class="leyenda">
                <strong>HASH: </strong> <?php echo $invoice['hash']?><br>
                Representación impresa de la <?php echo $tipocomprobante ?>, para ver el documento visita <br> <strong><?php echo $loc['web']?></strong><br>
                <?php echo $leyenda ?>
            </div>
            <table class="subtotal">          
                <tr>
                <td style="font-size: 12px"><strong>OP.GRAVADA:</strong></td>
                <td><?php echo amountExchange(0, $invoice['multi'], $invoice['loc']) ?></td>
                </tr>
                <tr class="f_summary">
                    
                    <td style="font-size: 12px"><strong>OP.INAFECTA:</strong></td>
                    <td><?php echo amountExchange(0, $invoice['multi'], $invoice['loc']) ?></td>
                </tr>
                <tr class="f_summary">
                    
                    <td style="font-size: 12px"><strong>OP.EXONERADA:</strong></td>
                    <td><?php echo amountExchange($sub_t, $invoice['multi'], $invoice['loc']); ?></td>
                </tr>
                <tr class="f_summary">
                    
                    <td style="font-size: 12px"><strong> IGV 18%:</strong></td>
                    <td><?php echo amountExchange($invoice['tax'], $invoice['multi'], $invoice['loc']) ?></td>
                </tr>';
                <?php
                if ($invoice['discount'] > 0) {
                    echo '<tr><td>&nbsp;</td>
            <td>' . $this->lang->line('Total Discount') . ':</td>
            <td>' . amountExchange($invoice['discount'], $invoice['multi'], $invoice['loc']) . '</td>
        </tr>';
                }
                if ($invoice['shipping'] > 0) {
                    echo '<tr>
            <td>' . $this->lang->line('Shipping') . ':</td>
            <td>' . amountExchange($invoice['shipping'], $invoice['multi'], $invoice['loc']) . '</td>
        </tr>';
                }
                ?>
                <tr>
                    
                    <td style="font-size: 13px"><strong>TOTAL:</strong></td>
                    <td><strong><?php echo amountExchange($invoice['total'], $invoice['multi'], $invoice['loc']); ?></strong></td>
                </tr>
            </table>
            </div>
    </body>
</html>