<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Invoice</title>
    <style type="text/css">
        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }
        body {
            position: relative;
            width: 100%;
            height: 29.7cm;
            margin: 0;
            color: #555555;
            background: #FFFFFF;
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        header {
            padding: 10px 0;
            margin-bottom: 20px;
            border-bottom: 1px solid #AAAAAA;
        }
        #logo {
            float: left;
            margin-top: 8px;
        }
        #logo img {
            height: 70px;
        }
        #company {
            float: right;
            text-align: right;
        }
        #details {
            margin-bottom: 50px;
        }
        #client {
            padding-left: 6px;
            border-left: 6px solid #0087C3;
            float: left;
        }
        #qrcode {
            margin-bottom: 20px;
            float: right;
        }
        #client .to {
            color: #777777;
        }
        h2.ruc {
            font-size: 1.2em;
            font-weight: normal;
            margin: 0;
        }
        #invoice {
            float: right;
            text-align: right;
        }
        #invoice h1 {
            color: #0087C3;
            font-size: 2em;
            line-height: 1em;
            font-weight: normal;
            margin: 0  0 10px 0;
        }
        #invoice .date {
            font-size: 1.1em;
            color: #777777;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
            margin-bottom: 20px;
        }
        table th,
        table td {
            padding: 20px;
            background: #EEEEEE;
            text-align: center;
            border-bottom: 1px solid #FFFFFF;
        }
        table th {
            white-space: nowrap;
            font-weight: normal;
        }
        table td {
            text-align: right;
        }
        table td h3{
            color: #57B223;
            font-size: 1.2em;
            font-weight: normal;
            margin: 0 0 0.2em 0;
        }
        table .no {
            color: #FFFFFF;
            font-size: 1.2em;
            text-align: center;
            background: #57B223;
        }
        table .desc {
            text-align: left;
            width: 50%;
        }
        table .unit {
            background: #DDDDDD;
            text-align: center;
        }
        table .qty {
        }
        table .total {
            background: #57B223;
            color: #FFFFFF;
        }
        table td.unit,
        table td.qty,
        table td.total {
            font-size: 1.2em;
            text-align: center;
        }
        table tbody tr:last-child td {
            border: none;
        }
        table tfoot td {
            padding: 10px 20px;
            background: #FFFFFF;
            border-bottom: none;
            font-size: 1.2em;
            white-space: nowrap;
            border-top: 1px solid #AAAAAA;
        }
        table tfoot tr:first-child td {
            border-top: none;
        }
        table tfoot tr td:last-child {
            text-align: center;
        }
        table tfoot tr:last-child td {
            color: #57B223;
            font-size: 1.4em;
            border-top: 1px solid #57B223;
        }
        table tfoot tr td:first-child {
            border: none;
        }
        #notices{
            padding-left: 6px;
            border-left: 6px solid #0087C3;
        }
        #notices .notice {
            font-size: 1.2em;
        }
        .name {
            font-size: 1.4em;
            margin: 0.2em 0;
        }
    </style>
</head>
<body>
<header class="clearfix">
    <div id="logo">
        <img src="{{ params.system.logo|image_b64 }}">
    </div>
    <div id="company">
        {% set cp = doc.company %}
        <h2 style="margin-bottom:0">RUC {{ cp.ruc }}</h2>
        <h3 style="margin:0.2em 0;font-size:1.3em">{{ cp.razonSocial }}</h3>
        <div>{{ cp.address.direccion }}</div>
        <div>{{ params.user.header|raw }}</div>
    </div>
</header>
<main>
    <div id="details" class="clearfix">
        <div id="client" style="max-width: 60%">
            <div class="to">EMITIDO A:</div>
            {% set cl = doc.client %}
            <h2 class="ruc"><b>{{ cl.tipoDoc|catalog('06') }}</b> {{ cl.numDoc }}</h2>
            <span class="name">{{ cl.rznSocial }}</span>
            {% if cl.address %}<div class="address"><i>{{ cl.address.direccion }}</i></div>{% endif %}
        </div>
        <div id="invoice">
            {% set serieNro = doc.serie ~ '-' ~ doc.correlativo %}
            <h1>{{ doc.tipoDoc|catalog('01') }} ELECTRÓNICA</h1>
            <h1>{{ serieNro }}</h1>
            <div class="date">EMITIDO: {{ doc.fechaEmision|date('d/m/Y') }}</div>
        </div>
    </div>
    <table border="0" cellspacing="0" cellpadding="0">
        <thead>
        <tr>
            <th class="no">CANT.</th>
            <th class="desc">DESCRIPCION</th>
            <th class="unit">UNIDAD</th>
            <th class="qty">P. UNIT</th>
            <th class="total">TOTAL</th>
        </tr>
        </thead>
        <tbody>
        {% set moneda = doc.tipoMoneda|catalog('02') %}
        {% for det in doc.details %}
            <tr>
                <td class="no">{{ det.cantidad|n_format }}</td>
                <td class="desc">
                    <h3>{{ det.codProducto }}</h3>
                    {{ det.descripcion }}
                </td>
                <td class="unit">{{ det.unidad }}</td>
                <td class="qty">{{ moneda }}{{ det.mtoValorUnitario }}</td>
                <td class="total">{{ moneda }}{{ det.mtoValorVenta }}</td>
            </tr>
        {% endfor %}
        </tbody>
        <tfoot>
        <tr>
            <td colspan="2"></td>
            <td colspan="2">Op. Gravadas</td>
            <td>{{ moneda }} {{ doc.mtoOperGravadas|n_format }}</td>
        </tr>
        {% if doc.mtoOperInafectas %}
            <tr>
                <td colspan="2"></td>
                <td colspan="2">Op. Inafectas</td>
                <td>{{ moneda }} {{  doc.mtoOperInafectas|n_format }}</td>
            </tr>
        {% endif %}
        {% if doc.mtoOperExoneradas %}
            <tr>
                <td colspan="2"></td>
                <td colspan="2">Op. Exoneradas</td>
                <td>{{ moneda }} {{  doc.mtoOperExoneradas|n_format }}</td>
            </tr>
        {% endif %}
        {% if doc.mtoOperGratuitas %}
            <tr>
                <td colspan="2"></td>
                <td colspan="2">Op. Gratuitas</td>
                <td>{{ moneda }} {{  doc.mtoOperGratuitas|n_format }}</td>
            </tr>
        {% endif %}
        <tr>
            <td colspan="2"></td>
            <td colspan="2">IGV (18%)</td>
            <td>{{ moneda }} {{  doc.mtoIGV|n_format }}</td>
        </tr>
        {% if doc.mtoISC %}
            <tr>
                <td colspan="2"></td>
                <td colspan="2">ISC</td>
                <td>{{ moneda }} {{  doc.mtoISC|n_format }}</td>
            </tr>
        {% endif %}
        {% if doc.mtoOtrosTributos %}
            <tr>
                <td colspan="2"></td>
                <td colspan="2">Otros Tributos</td>
                <td>{{ moneda }} {{  doc.mtoOtrosTributos|n_format }}</td>
            </tr>
        {% endif %}
        <tr>
            <td colspan="2"></td>
            <td colspan="2">TOTAL</td>
            <td>{{ moneda }} {{ doc.mtoImpVenta|n_format }}</td>
        </tr>
        </tfoot>
    </table>
    <hr>
    <div style="margin: 20px 0;width: 100%;text-align: center">
        <span>
            <b>IMPORTE EN LETRAS</b> {{ legend(doc.legends, '1000')  }}
        </span>
    </div>
    <div class="clearfix">
        <div style="float: left">
            <div id="notices">
                <div class="notice">
                    {% if params.system.hash is defined and params.system.hash%}
                        <strong>Resumen:</strong>   {{ params.system.hash }}<br>
                    {% endif %}
                    Representación Impresa de la {{ doc.tipoDoc|catalog('01') }} ELECTRÓNICA.
                </div>
            </div>
        </div>
        <div id="qrcode">
            <img src="{{ qrCode(doc)|image_b64('png') }}">
        </div>
    </div>
</main>
</body>
</html>

