<?php

ob_start();
tcpdf();




$estilo = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => '0');
$medidas = array(80, 890);
$obj_pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $medidas, true, 'UTF-8', false);
$obj_pdf->SetCreator(PDF_CREATOR);

$obj_pdf->SetTitle($invoice['nombre_docu']);
$obj_pdf->SetHeaderData($logo, 45, '', '','', '', '');
$obj_pdf->setHeaderFont(Array('dejavusans', '', 10));
$obj_pdf->SetDefaultMonospacedFont('dejavusans');
$obj_pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$obj_pdf->setPrintFooter(false);
$obj_pdf->SetMargins(2, 35, 2);
$obj_pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->setFontSubsetting(false);
$obj_pdf->AddPage();


$posicion = $obj_pdf->GetY();
$obj_pdf->SetFont('dejavusans', 'B', 10);
$obj_pdf->SetXY(0, $posicion);
$obj_pdf->MultiCell(80, 0, $loc['cname'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetFont('dejavusans', 'B', 10);
$obj_pdf->SetX(0, $posicion + 17);
$obj_pdf->MultiCell(80, 0, "RUC " . $loc['ruc'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$posicion = $obj_pdf->GetY();
$obj_pdf->SetFont('dejavusans', '', 8);

$obj_pdf->MultiCell(75, 0, strtoupper($loc['address'] . ' ' . $loc['country'] . '  ' . $loc['region']. '  ' . $loc['city']), 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$obj_pdf->SetFont('dejavusans', '', 7);
$obj_pdf->MultiCell(75, 0, strtoupper($loc['descripcion']), 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$obj_pdf->MultiCell(75, 0, strtoupper($loc['phone']), 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetFont('dejavusans', 'B', 10);

$obj_pdf->MultiCell(80, 0, $invoice['nombre_docu'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetFont('dejavusans', 'B', 10);

$obj_pdf->MultiCell(80, 0, $invoice['serie'] . "-" . $invoice['tid'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$posicion = $obj_pdf->GetY();

$obj_pdf->Line(2, $posicion + 3, 78, $posicion + 3, $estilo);
$posicion += 6;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $posicion);
$obj_pdf->Cell(2, 0, "RUC/DNI:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(20, $posicion);
$obj_pdf->Cell(2, 0, $invoice['numdoc'], 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(40, $posicion);


$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $posicion);
$obj_pdf->Cell(2, 0, "CLIENTE:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $posicion);
$obj_pdf->MultiCell(55, 0, $invoice['name'], 0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$hg = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $hg+1);
$obj_pdf->Cell(2, 0, "DIRECCIÓN:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $hg+1);
$obj_pdf->MultiCell(55, 0, $invoice['address'],0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$ht = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $ht+1);
$obj_pdf->Cell(2, 0, "F. EMISIÓN:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $ht+1);
$obj_pdf->Cell(2, 0, $invoice['invoicedate'], 0, 0, 'L');

$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $ht+6);
$obj_pdf->Cell(2, 0, "MONEDA:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $ht+6);
$obj_pdf->Cell(2, 0, $invoice['moneda'], 0, 0, 'L');

$posicion += 5;
$obj_pdf->Line(2, $ht+11, 78, $ht+11, $estilo);

$posicion += 2;
$obj_pdf->SetXY(2, $ht+14);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, 'ARTICULO                            P/U        IMP.');


$posicion += 5;
$obj_pdf->setY($ht+19);

foreach ($products as $fila) {
    $obj_pdf->setX(2);
    $obj_pdf->SetFont('dejavusans', '', 8);
    $obj_pdf->setX(18);
    $obj_pdf->Cell(42, 0, number_format($fila["price"], 2, ".", ","), 0, 0, "R");
    $obj_pdf->setX(32);
    $obj_pdf->Cell(44, 0, number_format($fila["subtotal"], 2, ".", ","), 0, 0, "R");
    $obj_pdf->setX(2);
    $obj_pdf->MultiCell(45, 0, strtoupper(substr('['.$fila["qty"].'] '.$fila["product"], 0, 80)), 0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
}
$h = $obj_pdf->GetY();
$obj_pdf->Line(2, $h + 2, 78, $h + 2, $estilo);
$obj_pdf->setY($h + 3);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "SUB TOTAL:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $moneda, 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($invoice['subtotal'], 2), 0, 0, 'R');

$obj_pdf->Line(2, $h + 2, 78, $h + 2, $estilo);

//$obj_pdf->setY($h + 7);
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(2, 4, "OP. GRAVADAS:", 0, 0, 'L');
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(72, 4, $moneda .' '.number_format($gravadas, 2), 0, 0, 'R');

$obj_pdf->setY($h + 7);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "OP. EXONERADAS:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $moneda, 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($invoice['subtotal'], 2), 0, 0, 'R');

//$obj_pdf->setY($h + 15);
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(2, 4, "OP. INAFECTAS:", 0, 0, 'L');
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(72, 4, $moneda.' '. number_format($inafectas, 2), 0, 0, 'R');

//$obj_pdf->setY($h + 19);
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(2, 4, "OP. GRATUITAS:", 0, 0, 'L');
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(72, 4, $moneda.' '.number_format($gratuitas, 2), 0, 0, 'R');

$obj_pdf->setY($h + 11);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "IGV:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $moneda, 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($invoice['tax'], 2), 0, 0, 'R');

$obj_pdf->setY($h + 15);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "ICBPER:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $moneda, 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($invoice['icbper'], 2), 0, 0, 'R');

$obj_pdf->setY($h + 19);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "DESC. GLOBAL:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $moneda, 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($invoice['discount'], 2), 0, 0, 'R');


$obj_pdf->setY($h + 23);
$obj_pdf->SetFont('dejavusans', 'B', 11);

$obj_pdf->MultiCell(76, 4, 'TOTAL: '. $moneda .' '. number_format($invoice['total'], 2), 0, 'R', 0, 1, '', '', true, 0, false, true, 0, 'T', false);


$obj_pdf->SetX(1);


$obj_pdf->setXY(2,$h + 27);
$obj_pdf->SetFont('dejavusans', '', 8);
$obj_pdf->SetX(2);
$obj_pdf->Cell(2, 6, 'SON: ' . num_to_letras($invoice['total'], $invoice['moneda']), 0, 0, 'L');
$obj_pdf->setXY(2,$h + 33);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "COND. DE PAGO:", 0, 0, 'L');
$obj_pdf->setXY(33,$h + 33);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $invoice['title'], 0, 0, 'L');

$obj_pdf->setXY(2,$h + 37);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "PAGÓ CON:", 0, 0, 'L');
$obj_pdf->setXY(25,$h + 37);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $moneda.' '.$invoice['efectivo'], 0, 0, 'L');

$obj_pdf->setXY(2,$h + 41);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "VUELTO:", 0, 0, 'L');
$obj_pdf->setXY(20,$h + 41);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $moneda.' '. number_format($invoice['vuelto'], 2), 0, 0, 'L');


$obj_pdf->setXY(2,$h + 45);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "USUARIO: ", 0, 0, 'L');
$obj_pdf->setXY(20,$h + 45);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $employee['name'], 0, 0, 'L');

$heigth = $obj_pdf->GetY();
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0, 0, 0),
    'bgcolor' => false, //array(255,255,255)
    'module_width' => 1, // width of a single module in points
    'module_height' => 1 // height of a single module in points
);
$obj_pdf->write2DBarcode($qrc, 'QRCODE,Q', 27, $heigth+5, 30, 30, $style, 'N');
$heigth = $obj_pdf->GetY();
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(0, $heigth);
$obj_pdf->MultiCell(80, 0, $invoice['hash'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->setXY(2, $heigth + 5);
$obj_pdf->SetFont('dejavusans', '', 8);
$obj_pdf->MultiCell(76, 0, 'REPRESENTACIÓN IMPRESA DE LA ' . $invoice['nombre_docu']. '. PARA CONSULTAR EL COMPROBANTE VISITA '. $loc['web'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->setXY(0, $heigth + 22);
$obj_pdf->SetFont('dejavusans', 'B', 8);
$obj_pdf->MultiCell(76, 0, 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA', 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$obj_pdf->setXY(2,$heigth + 34);
$obj_pdf->SetFont('dejavusans', 'B', 8);
if ($loc['ruc'] === '10011249006') {
    $n = '24';
} else {
    $n = '72';
}
$obj_pdf->MultiCell(75, 0, "NOTA: Estimado cliente, le recordamos que, pasadas las ". $n ." horas de recibida las existencias, no hay lugar "
        . "a reclamo.", 0, 'C',0,1,'','',true,0,false,true,0,'T',false);
$obj_pdf->setXY(0, $heigth + 47);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->MultiCell(80, 0, '¡GRACIAS POR SU PREFERENCIA!', 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->setXY(0, $heigth + 55);
$obj_pdf->SetFont('dejavusans', '', 7);
$obj_pdf->MultiCell(80, 0, '-- POWERED BY STARTFACT.COM.PE --', 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

ob_end_clean();

if ($d == 0){
    $obj_pdf->Output(FCPATH . 'userfiles/pos_temp/' .$invoice['serie'] . "-" . $invoice['tid'].'.pdf','I');
    
} else {
    $obj_pdf->Output($invoice['serie'] . "-" . $invoice['tid'].'.pdf','S');
    
}