<?php

ob_start();
tcpdf();




$estilo = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => '0');
$medidas = array(80, 120);
$obj_pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $medidas, true, 'UTF-8', false);
$obj_pdf->SetCreator(PDF_CREATOR);

$obj_pdf->SetTitle('Ticket de Caja');
//$obj_pdf->SetHeaderData($logo, 45, '', '','', '', '');
$obj_pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', 9));
$obj_pdf->SetDefaultMonospacedFont('times');
$obj_pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$obj_pdf->setPrintFooter(false);
$obj_pdf->SetMargins(2, 5, 2);
$obj_pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$obj_pdf->SetFont('times', '', 9);
$obj_pdf->setFontSubsetting(false);
$obj_pdf->AddPage();


$posicion = $obj_pdf->GetY();
$obj_pdf->SetFont('times', 'B', 10);
$obj_pdf->SetXY(0, $posicion);
$obj_pdf->MultiCell(80, 0, $loc['cname'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetFont('times', 'B', 10);
$obj_pdf->SetX(0, $posicion + 17);
$obj_pdf->MultiCell(80, 0, "RUC " . $loc['ruc'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$posicion = $obj_pdf->GetY();
$obj_pdf->SetFont('times', '', 8);

$obj_pdf->MultiCell(75, 0, strtoupper($loc['address'] . ' ' . $loc['country'] . '  ' . $loc['region']. '  ' . $loc['city']), 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$posicion = $obj_pdf->GetY();
$obj_pdf->SetFont('times', 'B', 10);
$obj_pdf->SetX(0, $posicion + 17);
$obj_pdf->MultiCell(80, 0, $caja['turno'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$posicion = $obj_pdf->GetY();

$obj_pdf->Line(2, $posicion + 3, 78, $posicion + 3, $estilo);
$posicion += 6;
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(2, $posicion);
$obj_pdf->Cell(2, 0, "EFECTIVO:", 0, 0, 'L');
$obj_pdf->SetFont('times', '', 8);
$obj_pdf->SetXY(60, $posicion);
$obj_pdf->Cell(2, 0, $caja['efectivo'], 0, 0, 'L');
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(40, $posicion);


$posicion += 5;
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(2, $posicion);
$obj_pdf->Cell(2, 0, "PASE DE TARJETA (POS):", 0, 0, 'L');
$obj_pdf->SetFont('times', '', 8);
$obj_pdf->SetXY(60, $posicion);
$obj_pdf->MultiCell(78, 0, $caja['tarjeta'], 0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$hg = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(2, $hg+1);
$obj_pdf->Cell(2, 0, "TRANSFERENCIA BANCARIA:", 0, 0, 'L');
$obj_pdf->SetFont('times', '', 8);
$obj_pdf->SetXY(60, $hg+1);
$obj_pdf->MultiCell(60, 0, $caja['banco'],0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$ht = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(2, $ht+1);
$obj_pdf->Cell(2, 0, "YAPE:", 0, 0, 'L');
$obj_pdf->SetFont('times', '', 8);
$obj_pdf->SetXY(60, $ht+1);
$obj_pdf->Cell(2, 0, $caja['yape'], 0, 0, 'L');
$ht = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(2, $ht+6);
$obj_pdf->Cell(2, 0, "PLIN:", 0, 0, 'L');
$obj_pdf->SetFont('times', '', 8);
$obj_pdf->SetXY(60, $ht+6);
$obj_pdf->Cell(2, 0, $caja['plin'], 0, 0, 'L');
$ht = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(2, $ht+6);
$obj_pdf->Cell(2, 0, "CHEQUES:", 0, 0, 'L');
$obj_pdf->SetFont('times', '', 8);
$obj_pdf->SetXY(60, $ht+6);
$obj_pdf->Cell(2, 0, $caja['cheques'], 0, 0, 'L');
$ht = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('times', 'B', 8);
$obj_pdf->SetXY(2, $ht+6);
$obj_pdf->Cell(2, 0, "CAMBIOS:", 0, 0, 'L');
$obj_pdf->SetFont('times', '', 8);
$obj_pdf->SetXY(60, $ht+6);
$obj_pdf->Cell(2, 0, $caja['cambios'], 0, 0, 'L');

$posicion += 5;
$obj_pdf->Line(2, $ht+11, 78, $ht+11, $estilo);



ob_end_clean();
$obj_pdf->Output('ticket_caja.pdf','I');