<div class="content-body">
    <div class="card">
        <div class="card-header pb-0">
            <h3>AGREGAR NUEVO PRODUCTO</h3>
            <hr>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                </ul>
            </div>
        </div>

        <div id="notify" class="alert alert-success" style="display:none;">
            <a href="#" class="close" data-dismiss="alert">&times;</a>

            <div class="message"></div>
        </div>
        <div class="card-body">
            <form method="post" id="data_form">
                <input type="hidden" name="act" value="add_product">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="tipo" id="inlineRadio1" value="P" checked>
                            <label class="form-check-label" for="inlineRadio1">Producto</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="tipo" id="inlineRadio2" value="S">
                            <label class="form-check-label" for="inlineRadio2">Servicio</label>
                        </div>
                    </div>
                </div>
                <br>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label class="col-form-label" for="product_name">Nombre del Producto*</label>
                        <input type="text" placeholder="Nombre del Producto" class="form-control margin-bottom required" name="product_name">
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="product_marca">Marca</label>
                        <select id="marca" name="product_marca" class="form-control">
                            <?php foreach ($marca as $value) { ?>
                                <option value="<?php echo $value['id'] ?>"><?php echo $value['marca'] ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-sm-1">
                        <label class="col-form-label" for="product_color">Color</label>
                        <select id="color" name="product_color" class="form-control">
                            <?php foreach ($color as $value) { ?>
                                <option value="<?php echo $value['id'] ?>"><?php echo $value['color'] ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-sm-1">
                        <label class="col-form-label" for="product_talla">Talla</label>
                        <select id="tallas" name="product_talla" class="form-control">
                            <?php foreach ($tallamedida as $value) { ?>
                                <option value="<?php echo $value['id'] ?>"><?php echo $value['talla'] ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="product_code"><?php echo $this->lang->line('Product Code') ?></label>
                        <input type="text" placeholder="<?php echo $this->lang->line('Product Code') ?>" class="form-control" name="product_code">
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="product_cat"><?php echo $this->lang->line('Product Category') ?>*</label>
                        <select name="product_cat" id="product_cat" class="form-control">
                            <?php
                            foreach ($cat as $row) {
                                $cid = $row['id'];
                                $title = $row['title'];
                                echo "<option value='$cid'>$title</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="sub_cat"><?php echo $this->lang->line('Sub') ?><?php echo $this->lang->line('Category') ?></label>
                        <select id="sub_cat" name="sub_cat" class="form-control required select-box">
                        </select>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="product_cat"><?php echo $this->lang->line('Warehouse') ?>*</label>
                        <div class="input-group">
                            <select name="product_warehouse" class="form-control">
                                <?php
                                foreach ($warehouse as $row) {
                                    $cid = $row['id'];
                                    $title = $row['title'];
                                    echo "<option value='$cid'>$title</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="product_price">Precio de Venta*</label>
                        <div class="input-group">
                            <span class="input-group-addon"><?php echo $this->config->item('currency') ?></span>
                            <input type="text" name="product_price" class="form-control required" placeholder="0.00" aria-describedby="sizing-addon" onkeypress="return isNumber(event)">
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="preciomin">Precio Mínimo*</label>
                        <div class="input-group">
                            <span class="input-group-addon"><?php echo $this->config->item('currency') ?></span>
                            <input type="text" name="preciomin" class="form-control required" placeholder="0.00" aria-describedby="sizing-addon" onkeypress="return isNumber(event)">
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label">Precio de Compra</label>
                        <div class="input-group">
                            <span class="input-group-addon"><?php echo $this->config->item('currency') ?></span>
                            <input type="text" name="fproduct_price" class="form-control" placeholder="0.00" aria-describedby="sizing-addon1" onkeypress="return isNumber(event)">
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label" for="product_cat"><?php echo $this->lang->line('Measurement Unit') ?>*</label>
                        <select name="unit" id="unidad" class="form-control">
                            <option value=''>Ninguno</option>
                            <?php
                            foreach ($units as $row) {
                                $cid = $row['code'];
                                $title = $row['name'];
                                echo "<option value='$cid'>$title - $cid</option>";
                            }
                            ?>
                        </select>
                    </div>
                </div>

                <hr>
                <div class="form-group row">
                    <div class="col-sm-2">
                        <label class="col-form-label">Impuesto Bolsas</label>
                        <div class="input-group">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="impbol" id="icbpersi" value="SI">
                                <label class="form-check-label" for="icbpersi">Si</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="impbol" id="icbperno" value="NO" checked>
                                <label class="form-check-label" for="icbperno">No</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label">ICBPER</label>
                        <div class="input-group">
                            <span class="input-group-addon"><?php echo $this->config->item('currency') ?></span>
                            <input type="text" name="product_icbper" class="form-control" id="product_icbper" placeholder="Ej. 0.20" value="0.00" aria-describedby="sizing-addon1" onkeypress="return isNumber(event)" disabled="">
                            <small>Digite el impuesto de la bolsa plástica de este año</small>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label">% IGV</label>
                        <div class="input-group">

                            <input type="text" name="product_tax" class="form-control" placeholder="<?php echo $this->lang->line('Default TAX Rate') ?>" aria-describedby="sizing-addon1" onkeypress="return isNumber(event)"><span class="input-group-addon">%</span>
                            <small><?php echo $this->lang->line('Tax rate during') ?></small>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label">% Descuento</label>
                        <div class="input-group">

                            <input type="text" name="product_disc" class="form-control" placeholder="<?php echo $this->lang->line('Default Discount Rate') ?>" aria-describedby="sizing-addon1" onkeypress="return isNumber(event)"><span class="input-group-addon">%</span>
                            <small><?php echo $this->lang->line('Discount rate during') ?></small>                            
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label">Stock</label>
                        <input type="text" placeholder="<?php echo $this->lang->line('Stock Units') ?>*" class="form-control margin-bottom required" id="stockp" name="product_qty" onkeypress="return isNumber(event)">
                    </div>
                    <div class="col-sm-2">
                        <label class="col-form-label">Cantidad de alerta</label>
                        <input type="text" placeholder="<?php echo $this->lang->line('Alert Quantity') ?>" class="form-control margin-bottom" id="cantal" name="product_qty_alert" onkeypress="return isNumber(event)">
                    </div>
                </div>
                <hr>
                <div class="form-group row">

                    <label class="col-sm-2 col-form-label"><?php echo $this->lang->line('BarCode') ?></label>
                    <div class="col-sm-2">
                        <select class="form-control" name="code_type">
                            <option value="EAN13">EAN13 - Predeterminado</option>
                            <option value="UPCA">UPC</option>
                            <option value="EAN8">EAN8</option>
                            <option value="ISSN">ISSN</option>
                            <option value="ISBN">ISBN</option>
                            <option value="C128A">C128A</option>
                            <option value="C39">C39</option>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <input type="text" placeholder="Código numérico de código de barras 123112345671" class="form-control margin-bottom" name="barcode" onkeypress="return isNumber(event)">
                        <small>Déjelo en blanco si desea generar automáticamente en EAN13.</small>
                    </div>

                    <div class="col-sm-4">
                        <div class="input-group">
                        
                            <input type="text" placeholder="Código SUNAT" class="form-control margin-bottom required" name="codsunat" id="codsunat" onkeypress="return isNumber(event)" value="<?php echo $codigosunat?>" required=""  readonly>
                            <div class="input-group-prepend">
                                <a href="javascript:void(0)" data-toggle="modal" data-target="#buscarCodS"><span class="input-group-text btn-primary" id="inputGroup-sizing-default"><i class="fa fa-search"></i> Buscar</a>
                            </div>
                            <small>Código de producto SUNAT obligatorio.</small>
                        </div>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label"><?php echo $this->lang->line('Description') ?></label>
                    <div class="col-sm-6">
                        <textarea placeholder="Descripción" class="form-control margin-bottom" name="product_desc"></textarea>
                    </div>
                    
                    <label class="col-sm-2 col-form-label">Tipo Existencia</label>
                    <div class="col-sm-2">
                        <select class="form-control margin-bottom" name="tipoexist">
                           <?php
                            foreach ($tipoexis as $row) {
                                $cid = $row['idtipoexistencia'];
                                $title = $row['tipoexistencia'];
                                echo "<option value='$cid'>$title - $cid</option>";
                            }
                            ?> 
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 control-label" for="edate"><?php echo $this->lang->line('Valid') . ' (' . $this->lang->line('To Date') ?>)</label>

                    <div class="col-sm-2">
                        <input type="text" class="form-control required" placeholder="Fecha de caducidad" name="wdate" data-toggle="datepicker" autocomplete="false">
                    </div>
                    <small>No cambie si no corresponde</small>
                </div>
                <?php
                foreach ($custom_fields as $row) {
                    if ($row['f_type'] == 'text') {
                        ?>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label"
                                   for="custom"><?= $row['name'] ?></label>

                            <div class="col-sm-8">
                                <input type="text" placeholder="<?= $row['placeholder'] ?>" class="form-control margin-bottom b_input <?= $row['other'] ?>" name="custom[<?= $row['id'] ?>]">
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
                <hr>
                <div class="form-group row"><label
                        class="col-sm-2 col-form-label"><?php echo $this->lang->line('Image') ?></label>
                    <div class="col-sm-6">
                        <div id="progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <table id="files" class="files"></table>
                        <br>
                        <span class="btn btn-success fileinput-button">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Seleccione archivos...</span>
                            <!-- The file input field used as target for the file upload widget -->
                            <input id="fileupload" type="file" name="files[]">
                        </span>
                        <br>
                        <pre>Permitido: gif, jpeg, png (Utilice imágenes livianas y pequeñas para una carga rápida - 200 x 200)</pre>
                        <br>
                        <!-- The global progress bar -->
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label"></label>
                    <div class="col-sm-4">
                        <input type="submit" id="submit-data" class="btn btn-lg btn-blue margin-bottom" value="<?php echo $this->lang->line('Add product') ?>" data-loading-text="Añadiendo...">
                        <input type="hidden" value="products/addproduct" id="action-url">
                    </div>
                </div>
                <button class="btn btn-pink add_serial btn-sm m-1">   <?php echo $this->lang->line('add_serial') ?></button><div id="added_product"></div>
                <div id="accordionWrapa1" role="tablist" aria-multiselectable="true">
                    <div id="coupon4" class="card-header">
                        <a data-toggle="collapse" data-parent="#accordionWrapa1" href="#accordion41" aria-expanded="true" aria-controls="accordion41" class="card-title lead collapsed"><i class="fa fa-plus-circle"></i> Variaciones de productos</a>
                    </div>
                    <div id="accordion41" role="tabpanel" aria-labelledby="coupon4" class="card-collapse collapse" aria-expanded="false" style="height: 0px;">
                        <div class="row p-1">
                            <div class="col">
                                <button class="btn btn-blue tr_clone_add"><?php echo $this->lang->line('add_row') ?></button>
                                <hr>
                                <table class="table" id="v_var">
                                    <tr>
                                        <td><select name="v_type[]" class="form-control">
                                                <?php
                                                foreach ($variables as $row) {
                                                    $cid = $row['id'];
                                                    $title = $row['name'];
                                                    $title = $row['name'];
                                                    $variation = $row['variation'];
                                                    echo "<option value='$cid'>$variation - $title </option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        <td>
                                            <input value="" class="form-control" name="v_stock[]" placeholder="<?php echo $this->lang->line('Stock Units') ?>*">
                                        </td>
                                        <td>
                                            <input value="" class="form-control" name="v_alert[]" placeholder="<?php echo $this->lang->line('Alert Quantity') ?>*">
                                        </td>
                                        <td>
                                            <button class="btn btn-red tr_delete">Eliminar</button>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <div id="accordionWrapa2" role="tablist" aria-multiselectable="true">

                    <div id="coupon5" class="card-header">
                        <a data-toggle="collapse" data-parent="#accordionWrapa2" href="#accordion42"
                           aria-expanded="true" aria-controls="accordion41"
                           class="card-title lead collapsed"><i class="fa fa-plus-circle"></i>
                               <?php echo $this->lang->line('Add') . ' ' . $this->lang->line('Products') . ' ' . $this->lang->line('Warehouse') ?>
                        </a>
                    </div>
                    <div id="accordion42" role="tabpanel" aria-labelledby="coupon5"
                         class="card-collapse collapse" aria-expanded="false" style="height: 0px;">
                        <div class="row p-1">
                            <div class="col">
                                <button class="btn btn-blue tr_clone_add_w">Añadir fila</button>
                                <hr>
                                <table class="table" id="w_var">
                                    <tr>
                                        <td>
                                            <select name="w_type[]" class="form-control">
                                                <?php
                                                foreach ($warehouse as $row) {
                                                    $cid = $row['id'];
                                                    $title = $row['title'];
                                                    echo "<option value='$cid'>$title</option>";
                                                }
                                                ?>
                                            </select></td>
                                        <td><input value="" class="form-control" name="w_stock[]"
                                                   placeholder="<?php echo $this->lang->line('Stock Units') ?>*">
                                        </td>
                                        <td><input value="" class="form-control" name="w_alert[]"
                                                   placeholder="<?php echo $this->lang->line('Alert Quantity') ?>*">
                                        </td>
                                        <td>
                                            <button class="btn btn-red tr_delete">Eliminar</button>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="image" id="image" value="default.png">
            </form>
        </div>
    </div>
    <div class="modal fade" id="buscarCodS" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content ">
            <div id="notify_prod" class="alert alert-success" style="display:none;">
                <a href="#" class="close" data-dismiss="alert">&times;</a>
                <div class="message_prod"></div>
            </div>
                <!-- Modal Header -->
                <div class="modal-header bg-gradient-directional-info white">

                    <h4 class="modal-title" id="myModalLabel">
                        <i class="icon-user-plus"></i> Buscar Código Sunat
                    </h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                        <span class="sr-only"><?php echo $this->lang->line('Close') ?></span>
                    </button>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <p id="statusMsg"></p>
                    <div class="row">
                        <div class="col-sm-12">
                            <table id="codsunattable" class="table table-sm table-striped table-bordered zero-configuration" cellspacing="0"
                       width="100%">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>SEGMENTO</th>
                        <th>FAMILIA</th>
                        <th>CLASE</th>                        
                        <th>CÓDIGO SUNAT</th>
                        <th><?php echo $this->lang->line('Settings') ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
                                                      
                        </div>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <div id="info"></div>
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('Close') ?></button>
                    
                </div>
        </div>
    </div>
</div>
</div>
<script type="text/javascript">
            var table;

            $(document).ready(function () {

                //datatables
                table = $('#codsunattable').DataTable({

                    "processing": true, //Feature control the processing indicator.
                    "serverSide": true, //Feature control DataTables' server-side processing mode.
                    "order": [], //Initial no order.
                    "responsive": true,
                    
                   <?php datatable_lang();?>

                    // Load data for the table's content from an Ajax source
                    "ajax": {
                        "url": "<?php echo site_url('products/cod_sunat')?>",
                        "type": "POST",
                        'data': {'<?=$this->security->get_csrf_token_name()?>': crsf_hash,'group': '<?=$this->input->get('group')?>'}
                    },

                    //Set column definition initialisation properties.
                    "columnDefs": [
                        {
                            "targets": [0], //first column / numbering column
                            "orderable": false, //set not orderable
                        },
                    ],
                    dom: 'lfrtip',
                    lengthMenu: [10, 20, 50, 100],
                    

                });
                miniDash();


                $(document).on('click', ".select-object", function (e) {
                    e.preventDefault();
                    $('#codsunat').val($(this).attr('data-object-id'));
                    

                    $('#buscarCodS').modal('toggle');

//                    var actionurl = $('#view-action-url').val();
//                    $.ajax({
//                        url: baseurl + actionurl,
//                        data: 'id=' + $('#view-object-id').val() + '&' + crsf_token + '=' + crsf_hash,
//                        type: 'POST',
//                        dataType: 'html',
//                        success: function (data) {
//                            $('#view_object').html(data);
//
//                        }
//
//                    });

                });
            });
        </script>
<script src="<?php echo assets_url('assets/myjs/jquery.ui.widget.js'); ?>"></script>
<script src="<?php echo assets_url('assets/myjs/jquery.fileupload.js') ?>"></script>
<script>
                                /*jslint unparam: true */
                                /*global window, $ */
                                $(function () {
                                    'use strict';
                                    // Change this to the location of your server-side upload handler:
                                    var url = '<?php echo base_url() ?>products/file_handling';
                                    $('#fileupload').fileupload({
                                        url: url,
                                        dataType: 'json',
                                        formData: {'<?= $this->security->get_csrf_token_name() ?>': crsf_hash},
                                        done: function (e, data) {
                                            var img = 'default.png';
                                            $.each(data.result.files, function (index, file) {
                                                $('#files').html('<tr><td><a data-url="<?php echo base_url() ?>products/file_handling?op=delete&name=' + file.name + '" class="aj_delete"><i class="btn-danger btn-sm icon-trash-a"></i> ' + file.name + ' </a><img style="max-height:200px;" src="<?php echo base_url() ?>userfiles/product/' + file.name + '"></td></tr>');
                                                img = file.name;
                                            });

                                            $('#image').val(img);
                                        },
                                        progressall: function (e, data) {
                                            var progress = parseInt(data.loaded / data.total * 100, 10);
                                            $('#progress .progress-bar').css(
                                                    'width',
                                                    progress + '%'
                                                    );
                                        }
                                    }).prop('disabled', !$.support.fileInput)
                                            .parent().addClass($.support.fileInput ? undefined : 'disabled');
                                });

                                $(document).on('click', ".aj_delete", function (e) {
                                    e.preventDefault();

                                    var aurl = $(this).attr('data-url');
                                    var obj = $(this);

                                    jQuery.ajax({

                                        url: aurl,
                                        type: 'GET',
                                        dataType: 'json',
                                        success: function (data) {
                                            obj.closest('tr').remove();
                                            obj.remove();
                                        }
                                    });

                                });
                                $("#unidad").val('NIU');

                                $('#inlineRadio2').on('click', function () {

                                    $("#stockp").attr('disabled', 'disabled');
                                    $("#cantal").attr('disabled', 'disabled');
                                    $("#stockp").removeClass('required');
                                    $("#unidad").val('ZZ');
                                });

                                $('#inlineRadio1').on('click', function () {
                                    $("#stockp").removeAttr('disabled');
                                    $("#cantal").removeAttr('disabled');
                                    $("#stockp").addClass('required');
                                    $("#unidad").val('NIU');
                                });

                                $('#icbpersi').on('click', function () {

                                    $("#product_icbper").removeAttr('disabled');
                                    $("#product_icbper").addClass('required');
                                    $("#product_icbper").val(<?php $loc = location($loc); echo $loc['icbper'];?>)

                                });

                                $('#icbperno').on('click', function () {
                                    $("#product_icbper").attr('disabled', 'disabled');
                                    $("#product_icbper").removeClass('required');
                                });


                                $(document).on('click', ".tr_clone_add", function (e) {
                                    e.preventDefault();
                                    var n_row = $('#v_var').find('tbody').find("tr:last").clone();

                                    $('#v_var').find('tbody').find("tr:last").after(n_row);

                                });
                                $(document).on('click', ".tr_clone_add_w", function (e) {
                                    e.preventDefault();
                                    var n_row = $('#w_var').find('tbody').find("tr:last").clone();

                                    $('#w_var').find('tbody').find("tr:last").after(n_row);

                                });

                                $(document).on('click', ".tr_delete", function (e) {
                                    e.preventDefault();
                                    $(this).closest('tr').remove();
                                });


                                $("#sub_cat").select2();
                                $("#product_cat").on('change', function () {
                                    $("#sub_cat").val('').trigger('change');
                                    var tips = $('#product_cat').val();
                                    $("#sub_cat").select2({

                                        ajax: {
                                            url: baseurl + 'products/sub_cat?id=' + tips,
                                            dataType: 'json',
                                            type: 'POST',
                                            quietMillis: 50,
                                            data: function (product) {
                                                return {
                                                    product: product,
                                                    '<?= $this->security->get_csrf_token_name() ?>': crsf_hash
                                                };
                                            },
                                            processResults: function (data) {
                                                return {
                                                    results: $.map(data, function (item) {
                                                        return {
                                                            text: item.title,
                                                            id: item.id
                                                        }
                                                    })
                                                };
                                            },
                                        }
                                    });
                                });
                                $(document).on('click', ".v_delete_serial", function (e) {
                                    e.preventDefault();
                                    $(this).closest('div .serial').remove();
                                });
                                $(document).on('click', ".add_serial", function (e) {
                                    e.preventDefault();

                                    $('#added_product').append('<div class="form-group serial"><label for="field_s" class="col-lg-2 control-label"><?= $this->lang->line('serial') ?></label><div class="col-lg-10"><input class="form-control box-size" placeholder="<?= $this->lang->line('serial') ?>" name="product_serial[]" type="text"  value=""></div><button class="btn-sm btn-purple v_delete_serial m-1 align-content-end"><i class="fa fa-trash"></i> </button></div>');

                                });
</script>

