<div class="content-body">
    <div class="row">
        <div class="col-xl-4 col-lg-6 col-12">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="media d-flex">
                            <div class="media-body text-left">
                                <h3 class="success"><span id="dash_0"></span></h3>
                                <span>En Stock</span>
                            </div>
                            <div class="align-self-center">
                                <i class="icon-rocket success font-large-2 float-right"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6 col-12">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="media d-flex">
                            <div class="media-body text-left">
                                <h3 class="danger"><span id="dash_1"></span></h3>
                                <span>Agotados</span>
                            </div>
                            <div class="align-self-center">
                                <i class="icon-eyeglasses danger font-large-2 float-right"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-lg-6 col-12">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="media d-flex">
                            <div class="media-body text-left">
                                <h3 class="purple"><span id="dash_2"></span></h3>
                                <span>Total</span>
                            </div>
                            <div class="align-self-center">
                                <i class="icon-pie-chart purple font-large-2 float-right"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="card">
        <div class="card-header">
            <h5>Productos <a href="<?php echo base_url('products/add') ?>" class="btn btn-primary btn-sm rounded">
                    <?php echo $this->lang->line('Add new') ?>
                </a> <a href="<?php echo base_url('products') ?>?group=yes" class="btn btn-purple btn-sm rounded"><i class="ft-grid"></i></a> <a href="<?php echo base_url('products') ?>" class="btn btn-purple btn-sm rounded"><i class="ft-list"></i></a></h5>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                    <li><a data-action="close"><i class="ft-x"></i></a></li>
                </ul>
            </div>
        </div>
        <div class="card-content">
            <div id="notify" class="alert alert-success" style="display:none;">
                <a href="#" class="close" data-dismiss="alert">&times;</a>

                <div class="message"></div>
            </div>

            <div class="card-body">

                <?php $loc = location($this->aauth->get_user()->loc);
                $th = '';
                if ($loc['codigosunat'] === '73141700') {
                    $th = '<th>Talla</th>';
                }
                ?>

                <table id="productstable" class="table table-hover table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Marca</th>
                            <th>Color</th>
                            <?php echo $th ?>
                            <th>Stock</th>
                            <th>Código</th>
                            <th>Categoría</th>
                            <th>Tipo Producto</th>
                            <th>Almacén</th>
                            <th>Precio Público</th>
                            <th>Precio x Mayor</th>
                            <th>Precio Compra</th>
                            <th>Configuraciones</th>
                        </tr>
                        <tr id="filterrow">
                            <th>#</th>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Marca</th>
                            <th>Color</th>
                            <?php echo $th ?>
                            <th>Stock</th>
                            <th>Código</th>
                            <th>Categoría</th>
                            <th>Tipo Producto</th>
                            <th>Almacén</th>
                            <th>Precio Público</th>
                            <th>Precio x Mayor</th>
                            <th>Precio Compra</th>
                            <th>Configuraciones</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>

                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Marca</th>
                            <th>Color</th>
                            <?php echo $th ?>
                            <th>Stock</th>
                            <th>Código</th>
                            <th>Categoría</th>
                            <th>Tipo Producto</th>
                            <th>Almacén</th>
                            <th>Precio Público</th>
                            <th>Precio x Mayor</th>
                            <th>Precio Compra</th>
                            <th>Configuraciones</th>
                        </tr>
                    </tfoot>
                </table>

            </div>
            <input type="hidden" id="dashurl" value="products/prd_stats">
        </div>
        <script type="text/javascript">
            var table;

            $(document).ready(function() {

                //datatables
                table = $('#productstable').DataTable({

                    "processing": true, //Feature control the processing indicator.
                    "serverSide": true, //Feature control DataTables' server-side processing mode.
                    "order": [], //Initial no order.
                    "ordering": false,
                    responsive: true,

                    <?php datatable_lang(); ?>

                    // Load data for the table's content from an Ajax source
                    "ajax": {
                        "url": "<?php echo site_url('products/product_list') ?>",
                        "type": "POST",
                        'data': {
                            '<?= $this->security->get_csrf_token_name() ?>': crsf_hash,
                            'group': '<?= $this->input->get('group') ?>'
                        }
                    },
                    createdRow: function(row, data, rowIndex) {
                        $.each($('td', row), function(colIndex) {
                            if (colIndex == 3) {
                                $(this).attr('data-name', 'marca');
                                $(this).attr('class', 'marca');
                                $(this).attr('data-type', 'text');
                                $(this).attr('data-pk', data[1]);
                            }
                            if (colIndex == 4) {
                                $(this).attr('data-name', 'color');
                                $(this).attr('class', 'color');
                                $(this).attr('data-type', 'text');
                                $(this).attr('data-pk', data[1]);
                            }
                            if (colIndex == 5) {
                                $(this).attr('data-name', 'qty');
                                $(this).attr('class', 'qty');
                                $(this).attr('data-type', 'text');
                                $(this).attr('data-pk', data[1]);
                            }
                            if (colIndex == 6) {
                                $(this).attr('data-name', 'product_code');
                                $(this).attr('class', 'product_code');
                                $(this).attr('data-type', 'text');
                                $(this).attr('data-pk', data[1]);
                            }
                            if (colIndex == 10) {
                                $(this).attr('data-name', 'product_price');
                                $(this).attr('class', 'precio');
                                $(this).attr('data-type', 'text');
                                $(this).attr('data-pk', data[1]);
                            }
                            if (colIndex == 11) {
                                $(this).attr('data-name', 'precio_min');
                                $(this).attr('class', 'preciomin');
                                $(this).attr('data-type', 'text');
                                $(this).attr('data-pk', data[1]);
                            }
                            if (colIndex == 12) {
                                $(this).attr('data-name', 'fproduct_price');
                                $(this).attr('class', 'preciocompra');
                                $(this).attr('data-type', 'text');
                                $(this).attr('data-pk', data[1]);
                            }
                            
                        });
                    },

                    //Set column definition initialisation properties.
                    "columnDefs": [{
                        "targets": [0], //first column / numbering column
                        "orderable": false, //set not orderable
                    }, ],
                    dom: 'Blfrtip',
                    lengthMenu: [10, 20, 50, 100, 200, 500],
                    buttons: [{
                        extend: 'excelHtml5',
                        footer: true,
                        exportOptions: {
                            columns: [1, 2, 3, 4, 5, 6, 7]
                        }
                    }],

                });
                $.fn.editable.defaults.mode = 'inline';
                $('#productstable').editable({
                    container: 'body',
                    selector: 'td.marca',
                    url: '<?= base_url() ?>products/editajax',
                    title: 'Marca',
                    type: 'POST',
                    validate: function(value) {
                        if ($.trim(value) == '') {
                            return 'El campo es requerido';
                        }
                    }
                });
                $('#productstable').editable({
                    container: 'body',
                    selector: 'td.color',
                    url: '<?= base_url() ?>products/editajax',
                    title: 'Color',
                    type: 'POST',
                    validate: function(value) {
                        if ($.trim(value) == '') {
                            return 'El campo es requerido';
                        }
                    }
                });
                $('#productstable').editable({
                    container: 'body',
                    selector: 'td.qty',
                    url: '<?= base_url() ?>products/editajax',
                    title: 'Stock',
                    type: 'POST',
                    validate: function(value) {
                        if ($.trim(value) == '') {
                            return 'El campo es requerido';
                        }
                    }
                });
                $('#productstable').editable({
                    container: 'body',
                    selector: 'td.product_code',
                    url: '<?= base_url() ?>products/editajax',
                    title: 'Código',
                    type: 'POST',
                    validate: function(value) {
                        if ($.trim(value) == '') {
                            return 'El campo es requerido';
                        }
                    }
                });
                $('#productstable').editable({
                    container: 'body',
                    selector: 'td.preciocompra',
                    url: '<?= base_url() ?>products/editajax',
                    title: 'Precio Compra',
                    type: 'POST',
                    validate: function(value) {
                        if ($.trim(value) == '') {
                            return 'El campo es requerido';
                        }
                    }
                });

                $('#productstable').editable({
                    container: 'body',
                    selector: 'td.precio',
                    url: '<?= base_url() ?>products/editajax',
                    title: 'Precio',
                    type: 'POST',
                    validate: function(value) {
                        if ($.trim(value) == '') {
                            return 'El campo es requerido';
                        }
                    }
                });
                $('#productstable').editable({
                    container: 'body',
                    selector: 'td.preciomin',
                    url: '<?= base_url() ?>products/editajax',
                    title: 'Precio x Mayor',
                    type: 'POST',
                    validate: function(value) {
                        if ($.trim(value) == '') {
                            return 'El campo es requerido';
                        }
                    }
                });


                miniDash();



                $('#productstable thead tr#filterrow th').each(function() {
                    var title = $('#productstable thead th').eq($(this).index()).text();
                    $(this).html('<input type="text" class="form-control" onclick="stopPropagation(event);" placeholder="Buscar" />');
                });

                $("#productstable thead input").on('keyup change', function() {
                    table.column($(this).parent().index() + ':visible')
                        .search(this.value)
                        .draw();
                });
                $(document).on('click', ".view-object", function(e) {
                    e.preventDefault();
                    $('#view-object-id').val($(this).attr('data-object-id'));

                    $('#view_model').modal({
                        backdrop: 'static',
                        keyboard: false
                    });

                    var actionurl = $('#view-action-url').val();
                    $.ajax({
                        url: baseurl + actionurl,
                        data: 'id=' + $('#view-object-id').val() + '&' + crsf_token + '=' + crsf_hash,
                        type: 'POST',
                        dataType: 'html',
                        success: function(data) {
                            $('#view_object').html(data);

                        }

                    });

                });
            });
        </script>
        <div id="delete_model" class="modal fade">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">

                        <h4 class="modal-title"><?php echo $this->lang->line('Delete') ?></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo $this->lang->line('delete this product') ?></p>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" id="object-id" value="">
                        <input type="hidden" id="action-url" value="products/delete_i">
                        <button type="button" data-dismiss="modal" class="btn btn-primary" id="delete-confirm"><?php echo $this->lang->line('Delete') ?></button>
                        <button type="button" data-dismiss="modal" class="btn"><?php echo $this->lang->line('Cancel') ?></button>
                    </div>
                </div>
            </div>
        </div>

        <div id="view_model" class="modal  fade">
            <div class="modal-dialog modal-lg">
                <div class="modal-content ">
                    <div class="modal-header">

                        <h4 class="modal-title"><?php echo $this->lang->line('View') ?></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body" id="view_object">
                        <p></p>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" id="view-object-id" value="">
                        <input type="hidden" id="view-action-url" value="products/view_over">

                        <button type="button" data-dismiss="modal" class="btn"><?php echo $this->lang->line('Close') ?></button>
                    </div>
                </div>
            </div>
        </div>