<div class="content-body">
    <div class="card">
        <div class="card-header">
            <h5 class="title"> <?php echo $this->lang->line('Business Registers') ?>
            </h5>
            <a href="<?= base_url() ?>register/ticketcaja" target="_blank" class="btn btn-primary" >Imprimir Reporte de Caja</a>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                    <li><a data-action="close"><i class="ft-x"></i></a></li>
                </ul>
            </div>
        </div>
        <hr>
        <div class="card-content">
            <div id="notify" class="alert alert-success" style="display:none;">
                <a href="#" class="close" data-dismiss="alert">&times;</a>

                <div class="message"></div>
            </div>
            <div class="card-body">


                <table id="regi_table" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo $this->lang->line('Employee Username') ?></th>
                            <th><?php echo $this->lang->line('Open Date') ?></th>
                            <th><?php echo $this->lang->line('Close Date') ?></th>
                            <th><?php echo $this->lang->line('Status') ?></th>
                            <th><?php echo $this->lang->line('Action') ?></th>


                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th><?php echo $this->lang->line('Employee') ?></th>
                            <th><?php echo $this->lang->line('Open Date') ?></th>
                            <th><?php echo $this->lang->line('Close Date') ?></th>
                            <th><?php echo $this->lang->line('Status') ?></th>
                            <th><?php echo $this->lang->line('Action') ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {

        $('#regi_table').DataTable({

            "processing": true,
            "serverSide": true,
            "stateSave": true,
            responsive: true,
            <?php datatable_lang(); ?> "ajax": {
                "url": "<?php echo site_url('register/load_list') ?>",
                "type": "POST",
                'data': {
                    '<?= $this->security->get_csrf_token_name() ?>': crsf_hash
                }
            },
            "columnDefs": [{
                "targets": [0],
                "orderable": true,
            }, ],
            dom: 'Blfrtip',
            buttons: [{
                extend: 'excelHtml5',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            }],

        });

        $(document).on('click', ".set-task", function(e) {
            e.preventDefault();
            $('#taskid').val($(this).attr('data-id'));

            $('#pop_model').modal({
                backdrop: 'static',
                keyboard: false
            });

        });


        $(document).on('click', ".view_task", function(e) {
            e.preventDefault();

            var actionurl = 'tools/view_task';
            var id = $(this).attr('data-id');
            $('#task_model').modal({
                backdrop: 'static',
                keyboard: false
            });


            $.ajax({

                url: baseurl + actionurl,
                type: 'POST',
                data: {
                    'tid': id,
                    '<?= $this->security->get_csrf_token_name() ?>': crsf_hash
                },
                dataType: 'json',
                success: function(data) {

                    $('#description').html(data.description);
                    $('#task_title').html(data.name);
                    $('#employee').html(data.employee);
                    $('#assign').html(data.assign);
                    $('#priority').html(data.priority);
                }

            });

        });


    });
</script>
<div id="delete_model" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">

                <h4 class="modal-title"><?php echo $this->lang->line('Delete') ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <p><?php echo $this->lang->line('Delete') ?> <?php echo $this->lang->line('Register') ?></strong></p>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="object-id" value="">
                <input type="hidden" id="action-url" value="register/delete_i">
                <button type="button" data-dismiss="modal" class="btn btn-primary" id="delete-confirm"><?php echo $this->lang->line('Delete') ?></button>
                <button type="button" data-dismiss="modal" class="btn"><?php echo $this->lang->line('Cancel') ?></button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="view_register" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content ">

            <!-- Modal Header -->
            <div class="modal-header">

                <h4 class="modal-title">Registro</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only"><?php echo $this->lang->line('Close') ?></span>
                </button>

            </div>

            <!-- Modal Body -->
            <div class="modal-body">


                <div class="row">
                    <div class="col-6">
                        <div class="form-group  text-bold-600 green">
                            <label for="amount">Efectivo
                            </label>
                            <input type="number" class="form-control green" id="r_cash" value="0.00" readonly>
                        </div>
                    </div>
                    <div class="col-6 col-md-6 pull-right">
                        <div class="form-group text-bold-600 blue">
                            <label for="b_change blue">Pase de Tarjeta (POS)</label>
                            <input type="number" class="form-control blue" id="r_card" value="0" readonly>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-6">
                        <div class="form-group  text-bold-600 indigo">
                            <label for="amount">Transferencia Bancaria
                            </label>
                            <input type="number" class="form-control indigo" id="r_bank" value="0.00" readonly>
                        </div>
                    </div>
                    <div class="col-6 col-md-6 pull-right">
                        <div class="form-group text-bold-600">
                            <label for="b_yape">Yape</label>
                            <input type="number" class="form-control" id="r_yape" value="0" readonly>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-6">

                        <div class="form-group text-bold-600">
                            <label for="b_plin">Plin</label>
                            <input type="number" class="form-control" id="r_plin" value="0" readonly>
                        </div>

                    </div>

                    <div class="col-6 col-md-6 pull-right">
                        <div class="form-group text-bold-600 red">
                            <label for="b_change">Cambios(-)</label>
                            <input type="number" class="form-control red" id="r_change" value="0" readonly>
                        </div>
                    </div>
                </div>



                <div class="row" style="display:none;">
                    <div class="col">
                        <p class="payment-errors"></p>
                    </div>
                </div>


                <!-- shipping -->


            </div>
            <!-- Modal Footer -->


        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).on('click', ".set-reg", function(e) {
        e.preventDefault();
        $.ajax({
            url: baseurl + 'register/view',
            dataType: 'json',
            type: 'POST',
            data: 'rid=' + $(this).attr('data-id') + '&<?= $this->security->get_csrf_token_name() ?>=' + crsf_hash,
            success: function(data) {
                $('#r_cash').val(data.cash);
                $('#r_card').val(data.card);
                $('#r_bank').val(data.bank);
                $('#r_yape').val(data.yape);
                $('#r_plin').val(data.plin);
                $('#r_change').val(data.change);
                $('#r_date').text(data.date);
            }
        });

    });
</script>