<?php
/**
 * Geo POS -  Accounting,  Invoicing  and CRM Software
 * Copyright (c) Rajesh Dukiya. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Invoices_model extends CI_Model
{
    var $table = 'jsoft_invoices';
    var $column_order = array(null, 'tid', 'name', 'invoicedate', 'total', 'status', null);
    var $column_search = array('tid', 'name', 'invoicedate', 'total');
    var $order = array('tid' => 'desc');

    public function __construct()
    {
        parent::__construct();
    }




        public function invoice_details($id)
    {
        $this->db->select('jsoft_invoices.*,jsoft_customers.*,jsoft_invoices.loc as loc,jsoft_invoices.id AS iid,jsoft_customers.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms');
        $this->db->from($this->table);
        $this->db->where('jsoft_invoices.id', $id);


        $this->db->join('jsoft_customers', 'jsoft_invoices.csd = jsoft_customers.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_invoices.term', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function invoice_products($id)
    {

        $this->db->select('*');
        $this->db->from('jsoft_invoice_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        return $query->result_array();

    }

    public function invoice_transactions($id)
    {

        $this->db->select('*');
        $this->db->from('jsoft_transactions');
        $this->db->where('tid', $id);
        $this->db->where('ext', 0);
        $query = $this->db->get();
        return $query->result_array();

    }


    private function _get_datatables_query()
    {

         $this->db->select('jsoft_invoices.id,jsoft_invoices.tid,jsoft_invoices.invoicedate,jsoft_invoices.invoiceduedate,jsoft_invoices.total,jsoft_invoices.status,jsoft_invoices.multi,jsoft_customers.name');
        $this->db->from($this->table);
        $this->db->where('jsoft_invoices.csd', $this->session->userdata('user_details')[0]->cid);
     //     $this->db->where('jsoft_invoices.i_class');
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd=jsoft_customers.id', 'left');

        $i = 0;

        foreach ($this->column_search as $item) // loop column
        {
            if ($_POST['search']['value']) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                } else {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables()
    {

        $this->_get_datatables_query();
        $this->db->where('jsoft_invoices.csd', $this->session->userdata('user_details')[0]->cid);
         // $this->db->where('jsoft_invoices.i_class', 0);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $this->db->where('jsoft_invoices.csd', $this->session->userdata('user_details')[0]->cid);
     //     $this->db->where('jsoft_invoices.i_class', 0);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->from($this->table);
        $this->db->where('jsoft_invoices.csd', $this->session->userdata('user_details')[0]->cid);
    //      $this->db->where('jsoft_invoices.i_class', 0);
        return $this->db->count_all_results();
    }


    public function billingterms()
    {
        $this->db->select('id,title');
        $this->db->from('jsoft_terms');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function employee($id)
    {
        $this->db->select('jsoft_employees.name,jsoft_employees.sign,jsoft_users.roleid');
        $this->db->from('jsoft_employees');
        $this->db->where('jsoft_employees.id', $id);
        $this->db->join('jsoft_users', 'jsoft_employees.id =jsoft_users.id', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }


}